/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.store.domain.IAction;
import org.springframework.security.core.GrantedAuthority;

public class AnterosSecurityGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private String authority;
    private String systemName;
    private String resourceName;
    private String actionName;

    public AnterosSecurityGrantedAuthority(IAction action) {
        this.makeAuthority(action);
    }

    private void makeAuthority(IAction action) {
        this.authority = action.getActionName();
        this.systemName = action.getResource().getSystem().getSystemName();
        this.resourceName = action.getResource().getResourceName();
        this.actionName = action.getActionName();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean equalsTo(String systemName, String resourceName, String actionName) {
        if (!systemName.equalsIgnoreCase(this.getSystemName())) {
            return false;
        }
        if (!resourceName.equalsIgnoreCase(this.getResourceName())) {
            return false;
        }
        return actionName.equalsIgnoreCase(this.getActionName());
    }
}

