/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.service;

import br.com.anteros.persistence.dsl.osql.types.OrderSpecifier;
import br.com.anteros.persistence.dsl.osql.types.Predicate;
import br.com.anteros.persistence.metadata.identifier.Identifier;
import br.com.anteros.persistence.session.repository.Page;
import br.com.anteros.persistence.session.repository.Pageable;
import br.com.anteros.persistence.session.service.SQLService;
import br.com.anteros.security.spring.ActionSecured;
import java.io.Serializable;
import java.util.List;

public interface SQLServiceSecured<T, ID extends Serializable>
extends SQLService<T, ID> {
    @ActionSecured(actionName="ACT_saveOne", category="Edi\u00e7\u00e3o", description="Salvar um entidade")
    public <S extends T> S save(S var1);

    @ActionSecured(actionName="ACT_saveMany", category="Edi\u00e7\u00e3o", description="Salvar v\u00e1rias entidades")
    public <S extends T> Iterable<S> save(Iterable<S> var1);

    @ActionSecured(actionName="ACT_saveAndFlush", category="Edi\u00e7\u00e3o", description="Salvar e descarregar uma entidade")
    public <S extends T> S saveAndFlush(S var1);

    @ActionSecured(actionName="ACT_flush", category="Edi\u00e7\u00e3o", description="Descarregar comandos da sess\u00e3o")
    public void flush();

    @ActionSecured(actionName="ACT_findOne", category="Busca", description="Busca uma entidade")
    public T findOne(ID var1);

    @ActionSecured(actionName="ACT_exists", category="Busca", description="Verifica se uma entidade existe")
    public boolean exists(ID var1);

    @ActionSecured(actionName="ACT_findAll", category="Busca", description="Busca todas as entidades")
    public List<T> findAll();

    @ActionSecured(actionName="ACT_findAllWithPage", category="Busca", description="Busca todas as entidades com pagina\u00e7\u00e3o")
    public Page<T> findAll(Pageable var1);

    @ActionSecured(actionName="ACT_find", category="Busca", description="Busca as entidades usando sql")
    public List<T> find(String var1);

    @ActionSecured(actionName="ACT_findWithPage", category="Busca", description="Busca as entidades usando sql e pagina\u00e7\u00e3o")
    public Page<T> find(String var1, Pageable var2);

    @ActionSecured(actionName="ACT_findWithParameters", category="Busca", description="Busca as entidades usando sql e parameters")
    public List<T> find(String var1, Object var2);

    @ActionSecured(actionName="ACT_findWithParametersAndPage", category="Busca", description="Busca as entidades usando sql com par\u00e2metros e pagina\u00e7\u00e3o")
    public Page<T> find(String var1, Object var2, Pageable var3);

    @ActionSecured(actionName="ACT_findByNamedQuery", category="Busca", description="Busca as entidades usando consulta nomeada")
    public List<T> findByNamedQuery(String var1);

    @ActionSecured(actionName="ACT_findByNamedQueryWithPage", category="Busca", description="Busca as entidades usando consulta nomeada e pagina\u00e7\u00e3o")
    public Page<T> findByNamedQuery(String var1, Pageable var2);

    @ActionSecured(actionName="ACT_findByNamedQueryWithParameters", category="Busca", description="Busca as entidades usando consulta nomeada com par\u00e2metros")
    public List<T> findByNamedQuery(String var1, Object var2);

    @ActionSecured(actionName="ACT_findByNamedQueryWithParamsAndPage", category="Busca", description="Busca as entidades usando consulta nomeada com par\u00e2metros")
    public Page<T> findByNamedQuery(String var1, Object var2, Pageable var3);

    @ActionSecured(actionName="ACT_findOneWithPredicate", category="Busca", description="Busca uma entidade usando predicado")
    public T findOne(Predicate var1);

    @ActionSecured(actionName="ACT_findOneBySql", category="Busca", description="Busca uma entidade")
    public T findOneBySql(String var1);

    @ActionSecured(actionName="ACT_findOneBySqlWithParameters", category="Busca", description="Busca uma entidade usando sql e par\u00e2metros")
    public T findOneBySql(String var1, Object var2);

    @ActionSecured(actionName="ACT_findAllWithPredicate", category="Busca", description="Busca todas as entidades com predicado")
    public List<T> findAll(Predicate var1);

    @ActionSecured(actionName="ACT_findAllWithPredicateAndOrder", category="Busca", description="Busca todas as entidades com predicado/ordena\u00e7\u00e3o")
    public Iterable<T> findAll(Predicate var1, OrderSpecifier<?> ... var2);

    @ActionSecured(actionName="ACT_findAllWithPredicateAndPage", category="Busca", description="Busca todas as entidades com predicado/pagina\u00e7\u00e3o")
    public Page<T> findAll(Predicate var1, Pageable var2);

    @ActionSecured(actionName="ACT_remove", category="Edi\u00e7\u00e3o", description="Remove uma entidade")
    public Page<T> findAll(Predicate var1, Pageable var2, OrderSpecifier<?> ... var3);

    @ActionSecured(actionName="ACT_refresh", category="Edi\u00e7\u00e3o", description="Atualiza um objeto")
    public void refresh(T var1);

    @ActionSecured(actionName="ACT_count", category="Edi\u00e7\u00e3o", description="Conta a quantidade de objetos")
    public long count();

    @ActionSecured(actionName="ACT_countByPredicate", category="Edi\u00e7\u00e3o", description="Conta a quantidade de objetos usando predicado")
    public long count(Predicate var1);

    @ActionSecured(actionName="ACT_removeById", category="Edi\u00e7\u00e3o", description="Remove uma entidade pelo ID")
    public void remove(ID var1);

    @ActionSecured(actionName="ACT_remove", category="Edi\u00e7\u00e3o", description="Remove uma entidade")
    public void remove(T var1);

    @ActionSecured(actionName="ACT_removeMany", category="Edi\u00e7\u00e3o", description="Remove v\u00e1rias entidades")
    public void remove(Iterable<? extends T> var1);

    @ActionSecured(actionName="ACT_removeAll", category="Edi\u00e7\u00e3o", description="Remove todas as entidades")
    public void removeAll();

    @ActionSecured(actionName="ACT_createIdentifier", category="Edi\u00e7\u00e3o", description="Cria um identificador")
    public Identifier<T> createIdentifier() throws Exception;

    @ActionSecured(actionName="ACT_getIdentifier", category="Edi\u00e7\u00e3o", description="Obt\u00e9m um identificador")
    public Identifier<T> getIdentifier(T var1) throws Exception;
}

