/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.scanner.ClassFilter;
import br.com.anteros.core.scanner.ClassPathResourceFilter;
import br.com.anteros.core.scanner.ClassPathScanner;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.security.model.Action;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.model.System;
import br.com.anteros.security.spring.ActionSecured;
import br.com.anteros.security.spring.AnterosSecurityAuthenticationToken;
import br.com.anteros.security.spring.AnterosSecurityException;
import br.com.anteros.security.spring.AnterosSecurityService;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.ResourceSecured;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.authentication.encoding.PlaintextPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component(value="anterosSecurityManager")
@ComponentScan(value={"br.com.anteros.security.spring"})
public class AnterosSecurityManager
implements AuthenticationProvider,
InitializingBean {
    protected String packageToScanSecurity;
    protected String systemName;
    protected String description;
    protected String version;
    protected boolean adminNeedsPermission = true;
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private static Logger LOG = LoggerProvider.getInstance().getLogger(AnterosSecurityManager.class.getName());
    private boolean initialized = false;
    @Autowired
    protected AnterosSecurityService anterosSecurityService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LOG.debug((Object)("Authenticate user " + authentication));
        String username = authentication.getName();
        UserDetails user = this.anterosSecurityService.loadUserByUsername(username, this.systemName);
        if (user == null) {
            throw new BadCredentialsException("Username not found.");
        }
        if (authentication.getCredentials() == null) {
            LOG.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        Object salt = null;
        if (this.saltSource != null) {
            salt = this.saltSource.getSalt(user);
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.isPasswordValid(user.getPassword(), presentedPassword, salt)) {
            LOG.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        ((AnterosSecurityUser)user).setSystemName(this.systemName);
        ((AnterosSecurityUser)user).setVersion(this.version);
        ((AnterosSecurityUser)user).setAdminNeedsPermission(this.adminNeedsPermission);
        Collection authorities = user.getAuthorities();
        return new AnterosSecurityAuthenticationToken(user, authentication.getCredentials(), authorities);
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    public void configure() throws Exception {
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotEmpty((String)this.systemName) && StringUtils.isNotEmpty((String)this.version) && StringUtils.isNotEmpty((String)this.packageToScanSecurity) && !this.initialized) {
            this.scanPackages();
            this.initialized = true;
        }
    }

    protected void scanPackages() {
        if (this.packageToScanSecurity != null && !"".equals(this.packageToScanSecurity)) {
            String[] packages = StringUtils.tokenizeToStringArray((String)this.packageToScanSecurity, (String)", ;");
            List scanClasses = ClassPathScanner.scanClasses((ClassPathResourceFilter[])new ClassPathResourceFilter[]{new ClassFilter().packages(packages).annotation(ResourceSecured.class)});
            this.loadSecuredResourcesAndActions(scanClasses);
        }
    }

    protected void loadSecuredResourcesAndActions(List<Class<?>> classes) {
        try {
            Action action = null;
            Resource resource = null;
            System system = this.anterosSecurityService.getSystemByName(this.systemName);
            if (system == null) {
                system = this.anterosSecurityService.addSystem(this.systemName, this.description);
            }
            for (Class<?> cl : classes) {
                if (!cl.isAnnotationPresent(ResourceSecured.class)) continue;
                ResourceSecured resourceSecured = cl.getAnnotation(ResourceSecured.class);
                resource = this.anterosSecurityService.getResourceByName(this.systemName, resourceSecured.resourceName());
                if (resource == null) {
                    resource = this.anterosSecurityService.addResource(system, resourceSecured.resourceName(), resourceSecured.description());
                    this.anterosSecurityService.refreshResource(resource);
                }
                Method[] methods = ReflectionUtils.getAllDeclaredMethods(cl);
                for (Method method : methods) {
                    if (!method.isAnnotationPresent(ActionSecured.class)) continue;
                    boolean found = false;
                    boolean active = false;
                    action = null;
                    ActionSecured actionSecured = method.getAnnotation(ActionSecured.class);
                    for (Action act : resource.getAcoes()) {
                        if (!act.getNome().equalsIgnoreCase(actionSecured.actionName())) continue;
                        found = true;
                        active = act.getAtiva();
                        action = act;
                        break;
                    }
                    if (!found) {
                        action = this.anterosSecurityService.addAction(system, resource, actionSecured.actionName(), actionSecured.category(), actionSecured.description(), this.version);
                        continue;
                    }
                    if (action == null) continue;
                    boolean save = false;
                    if (!active) {
                        action.setAtiva(Boolean.valueOf(true));
                        save = true;
                    }
                    if (!action.getCategoria().equalsIgnoreCase(actionSecured.category())) {
                        action.setCategoria(actionSecured.category());
                        save = true;
                    }
                    if (!save) continue;
                    this.anterosSecurityService.saveAction(action);
                }
                resource = this.anterosSecurityService.refreshResource(resource);
                for (Action act : resource.getAcoes()) {
                    boolean found = false;
                    for (Method method : methods) {
                        ActionSecured actionSecured;
                        if (!method.isAnnotationPresent(ActionSecured.class) || !(actionSecured = method.getAnnotation(ActionSecured.class)).actionName().equalsIgnoreCase(act.getNome())) continue;
                        found = true;
                        break;
                    }
                    if (found || act.getVersao().compareTo(this.version) >= 0) continue;
                    this.anterosSecurityService.removeActionByAllUsers(act);
                }
            }
        }
        catch (Exception e) {
            throw new AnterosSecurityException(e);
        }
    }

    public String getPackageToScanSecurity() {
        return this.packageToScanSecurity;
    }

    public AnterosSecurityManager setPackageToScanSecurity(String packageToScanSecurity) throws Exception {
        this.packageToScanSecurity = packageToScanSecurity;
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public AnterosSecurityManager setSystemName(String systemName) throws Exception {
        this.systemName = systemName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AnterosSecurityManager setDescription(String description) throws Exception {
        this.description = description;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public AnterosSecurityManager setVersion(String version) throws Exception {
        this.version = version;
        return this;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public boolean isAdminNeedsPermission() {
        return this.adminNeedsPermission;
    }

    public AnterosSecurityManager setAdminNeedsPermission(boolean adminNeedsPermission) throws Exception {
        this.adminNeedsPermission = adminNeedsPermission;
        return this;
    }
}

