/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.core.Authentication;

public class AnterosSecurityAccessDecisionManager
extends AbstractAccessDecisionManager {
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
    }

    public AnterosSecurityAccessDecisionManager(List<AccessDecisionVoter<? extends Object>> decisionVoters) {
        super(decisionVoters);
    }

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException {
        int deny = 0;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            int result = voter.vote(authentication, object, configAttributes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Voter: " + voter + ", returned: " + result));
            }
            switch (result) {
                case 1: {
                    return;
                }
                case -1: {
                    ++deny;
                    break;
                }
            }
        }
        if (deny > 0) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        this.checkAllowIfAllAbstainDecisions();
    }
}

