/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.spring.transaction.AnterosTransactionManager;
import br.com.anteros.springWeb.converter.AnterosHttpMessageConverter;
import br.com.anteros.springWeb.support.OpenSQLSessionInViewFilter;
import java.util.EventListener;
import java.util.List;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableTransactionManagement
@EnableWebMvc
public abstract class AnterosSpringSecurityMvcConfiguration
extends WebMvcConfigurerAdapter {
    private static final String OPEN_SQL_SESSION_IN_VIEW_FILTER = "OpenSQLSessionInViewFilter";
    private static final String SPRING_SECURITY_FILTER_CHAIN = "springSecurityFilterChain";
    private static final String DISPATCHER = "dispatcher";
    @Autowired
    private SQLSessionFactory sessionFactory;

    public void onStartup(ServletContext servletContext) throws ServletException {
        Class<?> clz;
        int n;
        int n2;
        Class<?>[] classArray;
        AnnotationConfigWebApplicationContext appContext = new AnnotationConfigWebApplicationContext();
        if (this.getDisplayName() != null) {
            appContext.setDisplayName(this.getDisplayName());
        }
        if (this.registerFirstConfigurationClasses() != null) {
            classArray = this.registerFirstConfigurationClasses();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                clz = classArray[n];
                appContext.register(new Class[]{clz});
                ++n;
            }
        }
        if (this.persistenceConfigurationClass() != null) {
            appContext.register(new Class[]{this.persistenceConfigurationClass()});
        }
        if (this.mvcConfigurationClass() != null) {
            appContext.register(new Class[]{this.mvcConfigurationClass()});
        }
        if (this.globalMethodSecurityConfigurationClass() != null) {
            appContext.register(new Class[]{this.globalMethodSecurityConfigurationClass()});
        }
        if (this.securityConfigurationClass() != null) {
            appContext.register(new Class[]{this.securityConfigurationClass()});
        }
        if (this.swaggerConfigurationClass() != null) {
            appContext.register(new Class[]{this.swaggerConfigurationClass()});
        }
        if (this.jsonDocConfigurationClass() != null) {
            appContext.register(new Class[]{this.jsonDocConfigurationClass()});
        }
        if (this.registerLastConfigurationClasses() != null) {
            classArray = this.registerLastConfigurationClasses();
            n2 = classArray.length;
            n = 0;
            while (n < n2) {
                clz = classArray[n];
                appContext.register(new Class[]{clz});
                ++n;
            }
        }
        appContext.setServletContext(servletContext);
        servletContext.addListener((EventListener)new ContextLoaderListener((WebApplicationContext)appContext));
        this.addListener(servletContext);
        this.addServlet(servletContext, appContext);
        ServletRegistration.Dynamic servlet = servletContext.addServlet(DISPATCHER, (Servlet)new DispatcherServlet((WebApplicationContext)appContext));
        servlet.addMapping(new String[]{"/"});
        servlet.setLoadOnStartup(1);
        FilterRegistration.Dynamic springSecurityFilterChain = servletContext.addFilter(SPRING_SECURITY_FILTER_CHAIN, DelegatingFilterProxy.class);
        springSecurityFilterChain.addMappingForUrlPatterns(null, false, new String[]{"/*"});
        FilterRegistration.Dynamic openSQLSessionInViewFilterChain = servletContext.addFilter(OPEN_SQL_SESSION_IN_VIEW_FILTER, OpenSQLSessionInViewFilter.class);
        openSQLSessionInViewFilterChain.addMappingForUrlPatterns(null, false, new String[]{"/*"});
    }

    public abstract Class<?>[] registerFirstConfigurationClasses();

    public abstract Class<?>[] registerLastConfigurationClasses();

    public abstract Class<?> persistenceConfigurationClass();

    public abstract Class<?> mvcConfigurationClass();

    public abstract Class<?> swaggerConfigurationClass();

    public abstract Class<?> securityConfigurationClass();

    public abstract Class<?> jsonDocConfigurationClass();

    public abstract Class<?> globalMethodSecurityConfigurationClass();

    public abstract void addListener(ServletContext var1);

    public abstract void addServlet(ServletContext var1, AnnotationConfigWebApplicationContext var2);

    public abstract String getDisplayName();

    @Autowired
    @Bean(name={"transactionManager"})
    public PlatformTransactionManager txManager(DataSource dataSource, SQLSessionFactory sessionFactory) {
        if (dataSource != null && sessionFactory != null) {
            AnterosTransactionManager txManager = new AnterosTransactionManager();
            txManager.setDataSource(dataSource);
            txManager.setSessionFactory(sessionFactory);
            return txManager;
        }
        return null;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        converters.add((HttpMessageConverter<?>)new AnterosHttpMessageConverter(this.sessionFactory));
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        super.addResourceHandlers(registry);
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"jsondoc-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }
}

