/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.security.spring.AnterosSecurityManager;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Configuration
@EnableWebSecurity
@ComponentScan(basePackages={"br.com.anteros.security"})
public abstract class AnterosSpringSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AnterosSecurityManager anterosSecurityManager;

    public abstract String systemName();

    public abstract String description();

    public abstract String version();

    public abstract Boolean adminNeedsPermission();

    public abstract String packageToScanSecurity();

    protected AuthenticationManager authenticationManager() throws Exception {
        this.configureAnterosSecurityManager();
        ArrayList<AnterosSecurityManager> providers = new ArrayList<AnterosSecurityManager>(1);
        providers.add(this.anterosSecurityManager);
        return new ProviderManager(providers);
    }

    private void configureAnterosSecurityManager() throws Exception {
        this.anterosSecurityManager.setDescription(this.description()).setAdminNeedsPermission(this.adminNeedsPermission()).setSystemName(this.systemName()).setVersion(this.version()).setPackageToScanSecurity(this.packageToScanSecurity()).configure();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(new String[]{"/resources/**"})).permitAll().antMatchers(new String[]{"/login*"})).permitAll().antMatchers(new String[]{"/**"})).authenticated().and()).formLogin().and()).csrf().disable();
    }

    @Autowired
    public void configureGlobalSecurity(AuthenticationManagerBuilder auth) throws Exception {
        this.configureAnterosSecurityManager();
        auth.authenticationProvider((AuthenticationProvider)this.anterosSecurityManager);
    }
}

