/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.service.GenericSQLService;
import br.com.anteros.security.model.Action;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.model.Security;
import br.com.anteros.security.model.System;
import br.com.anteros.security.model.User;
import br.com.anteros.security.spring.AnterosSecurityException;
import br.com.anteros.security.spring.AnterosSecurityService;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.repository.AnterosActionRepository;
import br.com.anteros.security.spring.repository.AnterosActionRepositoryImpl;
import br.com.anteros.security.spring.repository.AnterosResourceRepository;
import br.com.anteros.security.spring.repository.AnterosResourceRepositoryImpl;
import br.com.anteros.security.spring.repository.AnterosSecurityRepository;
import br.com.anteros.security.spring.repository.AnterosSecurityRepositoryImpl;
import br.com.anteros.security.spring.repository.AnterosSystemRepository;
import br.com.anteros.security.spring.repository.AnterosSystemRepositoryImpl;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="anterosSecurityService")
public class AnterosSecurityServiceImpl
extends GenericSQLService<Security, Long>
implements AnterosSecurityService,
InitializingBean {
    @Autowired
    protected AnterosSecurityRepository anterosSecurityRepository;
    @Autowired
    protected AnterosSystemRepository anterosSystemRepository;
    @Autowired
    protected AnterosResourceRepository anterosResourceRepository;
    @Autowired
    protected AnterosActionRepository anterosActionRepository;
    private Map<String, AnterosSecurityUser> cacheUsers = new HashMap<String, AnterosSecurityUser>();

    public AnterosSecurityServiceImpl() {
    }

    public AnterosSecurityServiceImpl(SQLSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        AnterosSecurityUser result = this.cacheUsers.get(username);
        if (result == null) {
            User user = this.anterosSecurityRepository.findUserByName(username);
            if (user == null) {
                return null;
            }
            result = new AnterosSecurityUser(user);
            user = null;
            this.cacheUsers.put(username, result);
        }
        return result;
    }

    @Override
    public UserDetails loadUserByUsername(String username, String systemName) throws UsernameNotFoundException {
        AnterosSecurityUser result = this.cacheUsers.get(username);
        if (result == null) {
            User user = this.anterosSecurityRepository.findUserByName(username);
            if (user == null) {
                return null;
            }
            result = new AnterosSecurityUser(user, systemName);
            user = null;
            this.cacheUsers.put(username, result);
        }
        return result;
    }

    @Override
    public Resource getResourceByName(String systemName, String resourceName) {
        Resource resource = (Resource)this.anterosResourceRepository.findOne("select rec.* from SEGURANCARECURSO rec, SEGURANCASISTEMA sis where sis.nome_sistema = :pnome_sistema and rec.nome_recurso = :pnome_recurso and rec.id_sistema = sis.id_sistema ", NamedParameter.list().addParameter("pnome_sistema", (Object)systemName).addParameter("pnome_recurso", (Object)resourceName).values());
        return resource;
    }

    @Override
    public System getSystemByName(String systemName) {
        System system = (System)this.anterosSystemRepository.findOne("select sis.* from SEGURANCASISTEMA sis where sis.nome_sistema = :pnome_sistema", new NamedParameter("pnome_sistema", (Object)systemName));
        return system;
    }

    @Override
    public System addSystem(String systemName, String description) throws Exception {
        System system = new System();
        system.setNome(systemName);
        system.setDescricao(description);
        try {
            this.anterosSystemRepository.getSession().getTransaction().begin();
            this.anterosSystemRepository.getSession().save((Object)system);
            this.anterosSystemRepository.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.anterosSystemRepository.getSession().getTransaction().rollback();
            throw new AnterosSecurityException("N\u00e3o foi poss\u00edvel salvar o sistema " + systemName + ". " + e.getMessage(), e);
        }
        return system;
    }

    @Override
    public Resource addResource(System system, String resourceName, String description) throws Exception {
        Resource resource = new Resource();
        resource.setNome(resourceName);
        resource.setDescricao(description);
        resource.setSistema(system);
        try {
            this.anterosResourceRepository.getSession().getTransaction().begin();
            this.anterosResourceRepository.getSession().save((Object)resource);
            this.anterosResourceRepository.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.anterosResourceRepository.getSession().getTransaction().rollback();
            throw new AnterosSecurityException("N\u00e3o foi poss\u00edvel salvar o recurso " + resourceName + ". " + e.getMessage(), e);
        }
        return resource;
    }

    @Override
    public Action addAction(System system, Resource resource, String actionName, String category, String description, String version) throws Exception {
        Action action = new Action();
        action.setNome(actionName);
        action.setDescricao(description);
        action.setCategoria(category);
        action.setRecurso(resource);
        action.setVersao(version);
        try {
            this.anterosActionRepository.getSession().getTransaction().begin();
            this.anterosActionRepository.getSession().save((Object)action);
            this.anterosActionRepository.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.anterosActionRepository.getSession().getTransaction().rollback();
            throw new AnterosSecurityException("N\u00e3o foi poss\u00edvel salvar a a\u00e7\u00e3o " + actionName + ". " + e.getMessage(), e);
        }
        return action;
    }

    @Override
    public Action saveAction(Action action) throws Exception {
        try {
            this.anterosActionRepository.getSession().getTransaction().begin();
            this.anterosActionRepository.getSession().save((Object)action);
            this.anterosActionRepository.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.anterosActionRepository.getSession().getTransaction().rollback();
            throw new AnterosSecurityException(e);
        }
        return action;
    }

    @Override
    public Resource refreshResource(Resource resource) {
        this.anterosResourceRepository.refresh(resource);
        return resource;
    }

    @Override
    public void removeActionByAllUsers(Action act) throws Exception {
        try {
            this.anterosActionRepository.getSession().getTransaction().begin();
            this.anterosActionRepository.getSession().createQuery("delete from SEGURANCAACAOACAO where id_acao = :pid_acao", (Object)new NamedParameter("pid_acao", (Object)act.getId())).executeQuery();
            this.anterosActionRepository.remove(act);
            this.anterosActionRepository.getSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.anterosActionRepository.getSession().getTransaction().rollback();
            throw new AnterosSecurityException(e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        SQLSession session = this.anterosSecurityRepository.getSQLSessionFactory().openSession();
        this.anterosSecurityRepository.setSession(session);
        this.anterosActionRepository.setSession(session);
        this.anterosResourceRepository.setSession(session);
        this.anterosSystemRepository.setSession(session);
    }

    @Override
    public User getUserByUserName(String username) {
        return this.anterosSecurityRepository.findUserByName(username);
    }

    public AnterosSecurityRepository getAnterosSecurityRepository() throws Exception {
        if (this.anterosSecurityRepository == null) {
            this.anterosSecurityRepository = new AnterosSecurityRepositoryImpl(this.sessionFactory);
        }
        return this.anterosSecurityRepository;
    }

    public AnterosSystemRepository getAnterosSystemRepository() throws Exception {
        if (this.anterosSystemRepository == null) {
            this.anterosSystemRepository = new AnterosSystemRepositoryImpl(this.sessionFactory);
        }
        return this.anterosSystemRepository;
    }

    public AnterosResourceRepository getAnterosResourceRepository() throws Exception {
        if (this.anterosResourceRepository == null) {
            this.anterosResourceRepository = new AnterosResourceRepositoryImpl(this.sessionFactory);
        }
        return this.anterosResourceRepository;
    }

    public AnterosActionRepository getAnterosActionRepository() throws Exception {
        if (this.anterosActionRepository == null) {
            this.anterosActionRepository = new AnterosActionRepositoryImpl(this.sessionFactory);
        }
        return this.anterosActionRepository;
    }
}

