/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.util;

import br.com.anteros.security.spring.AnterosSecurityAuthenticationToken;
import br.com.anteros.security.spring.AnterosSecurityUser;
import java.util.Collection;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public final class AnterosSecurityUtil {
    public static AnterosSecurityUser getLoggedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        return (AnterosSecurityUser)authentication.getPrincipal();
    }

    public static void clearAuthentication() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public static void manualAuthentication(UserDetails user, String systemName, String version, boolean adminNeedsPermission) {
        if (user == null) {
            throw new BadCredentialsException("Username is required.");
        }
        ((AnterosSecurityUser)user).setSystemName(systemName);
        ((AnterosSecurityUser)user).setVersion(version);
        ((AnterosSecurityUser)user).setAdminNeedsPermission(adminNeedsPermission);
        Collection authorities = user.getAuthorities();
        SecurityContextHolder.getContext().setAuthentication((Authentication)new AnterosSecurityAuthenticationToken(user, user.getPassword(), authorities));
    }
}

