/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring.config;

import br.com.anteros.security.spring.AnterosSecurityManager;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
@EnableWebSecurity
@ComponentScan(basePackages={"br.com.anteros.security"})
public abstract class AnterosSpringSecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private AnterosSecurityManager anterosSecurityManager;

    public abstract String systemName();

    public abstract String description();

    public abstract String version();

    public abstract Boolean adminNeedsPermission();

    public abstract String packageToScanSecurity();

    protected AuthenticationManager authenticationManager() throws Exception {
        this.configureAnterosSecurityManager();
        ArrayList<AnterosSecurityManager> providers = new ArrayList<AnterosSecurityManager>(1);
        providers.add(this.anterosSecurityManager);
        return new ProviderManager(providers);
    }

    private void configureAnterosSecurityManager() throws Exception {
        this.anterosSecurityManager.setDescription(this.description()).setAdminNeedsPermission(this.adminNeedsPermission()).setSystemName(this.systemName()).setVersion(this.version()).setPackageToScanSecurity(this.packageToScanSecurity()).configure();
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.cors().and()).authorizeRequests().antMatchers(new String[]{"/resources/**"})).permitAll().antMatchers(new String[]{"/login*"})).permitAll().anyRequest()).authenticated().and()).formLogin().and()).httpBasic();
    }

    @Autowired
    public void configureGlobalSecurity(AuthenticationManagerBuilder auth) throws Exception {
        this.configureAnterosSecurityManager();
        auth.authenticationProvider((AuthenticationProvider)this.anterosSecurityManager);
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList("*"));
        configuration.setAllowedMethods(Arrays.asList("HEAD", "GET", "POST", "PUT", "DELETE", "PATCH"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedHeaders(Arrays.asList("Authorization", "Cache-Control", "Content-Type"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

