/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.scanner.ClassFilter;
import br.com.anteros.core.scanner.ClassPathResourceFilter;
import br.com.anteros.core.scanner.ClassPathScanner;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.security.model.Action;
import br.com.anteros.security.model.Resource;
import br.com.anteros.security.model.System;
import br.com.anteros.security.spring.ActionSecured;
import br.com.anteros.security.spring.AnterosSecurityAuthenticationToken;
import br.com.anteros.security.spring.AnterosSecurityException;
import br.com.anteros.security.spring.AnterosSecurityService;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.ResourceSecured;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.authentication.encoding.PlaintextPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

@Component(value="anterosSecurityManager")
@ComponentScan(value={"br.com.anteros.security.spring"})
public class AnterosSecurityManager
implements AuthenticationProvider,
InitializingBean {
    protected String packageToScanSecurity;
    protected String systemName;
    protected String description;
    protected String version;
    protected boolean adminNeedsPermission = true;
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private static Logger LOG = LoggerProvider.getInstance().getLogger(AnterosSecurityManager.class.getName());
    private boolean initialized = false;
    private Map<String, AnterosSecurityUser> cacheUsers = new HashMap<String, AnterosSecurityUser>();
    @Autowired
    protected WebApplicationContext context;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        LOG.debug((Object)("Authenticate user " + authentication));
        String username = authentication.getName();
        AnterosSecurityUser user = this.cacheUsers.get(username);
        if (user == null) {
            AnterosSecurityService anterosSecurityService = (AnterosSecurityService)this.context.getBean("anterosSecurityService");
            user = (AnterosSecurityUser)anterosSecurityService.loadUserByUsername(username, this.systemName);
        }
        if (user == null) {
            throw new BadCredentialsException("Username not found.");
        }
        if (authentication.getCredentials() == null) {
            LOG.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        Object salt = null;
        if (this.saltSource != null) {
            salt = this.saltSource.getSalt((UserDetails)user);
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (!this.passwordEncoder.isPasswordValid(user.getPassword(), presentedPassword, salt)) {
            LOG.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException("Bad credentials " + user.getUsername());
        }
        user.setSystemName(this.systemName);
        user.setVersion(this.version);
        user.setAdminNeedsPermission(this.adminNeedsPermission);
        Collection<? extends GrantedAuthority> authorities = user.getAuthorities();
        return new AnterosSecurityAuthenticationToken(user, authentication.getCredentials(), authorities);
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    public void configure() throws Exception {
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotEmpty((String)this.systemName) && StringUtils.isNotEmpty((String)this.version) && StringUtils.isNotEmpty((String)this.packageToScanSecurity) && !this.initialized) {
            this.scanPackages();
            this.initialized = true;
        }
    }

    protected void scanPackages() {
        if (this.packageToScanSecurity != null && !"".equals(this.packageToScanSecurity)) {
            String[] packages = StringUtils.tokenizeToStringArray((String)this.packageToScanSecurity, (String)", ;");
            List scanClasses = ClassPathScanner.scanClasses((ClassPathResourceFilter[])new ClassPathResourceFilter[]{new ClassFilter().packages(packages).annotation(ResourceSecured.class)});
            this.loadSecuredResourcesAndActions(scanClasses);
        }
    }

    protected void loadSecuredResourcesAndActions(List<Class<?>> classes) {
        try {
            AnterosSecurityService anterosSecurityService = (AnterosSecurityService)this.context.getBean("anterosSecurityService");
            Action action = null;
            Resource resource = null;
            System system = anterosSecurityService.getSystemByName(this.systemName);
            if (system == null) {
                system = anterosSecurityService.addSystem(this.systemName, this.description);
            }
            for (Class<?> cl : classes) {
                Method[] methods;
                if (!cl.isAnnotationPresent(ResourceSecured.class)) continue;
                ResourceSecured resourceSecured = cl.getAnnotation(ResourceSecured.class);
                resource = anterosSecurityService.getResourceByName(this.systemName, resourceSecured.resourceName());
                if (resource == null) {
                    resource = anterosSecurityService.addResource(system, resourceSecured.resourceName(), resourceSecured.description());
                    anterosSecurityService.refreshResource(resource);
                }
                Method[] methodArray = methods = ReflectionUtils.getAllDeclaredMethods(cl);
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.isAnnotationPresent(ActionSecured.class)) {
                        boolean found = false;
                        boolean active = false;
                        action = null;
                        ActionSecured actionSecured = method.getAnnotation(ActionSecured.class);
                        for (Action act : resource.getAcoes()) {
                            if (!act.getNome().equalsIgnoreCase(actionSecured.actionName())) continue;
                            found = true;
                            active = act.getAtiva();
                            action = act;
                            break;
                        }
                        if (!found) {
                            action = anterosSecurityService.addAction(system, resource, actionSecured.actionName(), actionSecured.category(), actionSecured.description(), this.version);
                        } else if (action != null) {
                            boolean save = false;
                            if (!active) {
                                action.setAtiva(Boolean.valueOf(true));
                                save = true;
                            }
                            if (!action.getCategoria().equalsIgnoreCase(actionSecured.category())) {
                                action.setCategoria(actionSecured.category());
                                save = true;
                            }
                            if (save) {
                                anterosSecurityService.saveAction(action);
                            }
                        }
                    }
                    ++n2;
                }
                resource = anterosSecurityService.refreshResource(resource);
                for (Action act : resource.getAcoes()) {
                    boolean found = false;
                    Method[] methodArray2 = methods;
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ActionSecured actionSecured;
                        Method method = methodArray2[n4];
                        if (method.isAnnotationPresent(ActionSecured.class) && (actionSecured = method.getAnnotation(ActionSecured.class)).actionName().equalsIgnoreCase(act.getNome())) {
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (found || act.getVersao().compareTo(this.version) >= 0) continue;
                    anterosSecurityService.removeActionByAllUsers(act);
                }
            }
            anterosSecurityService = null;
        }
        catch (Exception e) {
            throw new AnterosSecurityException(e);
        }
    }

    public String getPackageToScanSecurity() {
        return this.packageToScanSecurity;
    }

    public AnterosSecurityManager setPackageToScanSecurity(String packageToScanSecurity) throws Exception {
        this.packageToScanSecurity = packageToScanSecurity;
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public AnterosSecurityManager setSystemName(String systemName) throws Exception {
        this.systemName = systemName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public AnterosSecurityManager setDescription(String description) throws Exception {
        this.description = description;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public AnterosSecurityManager setVersion(String version) throws Exception {
        this.version = version;
        return this;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public boolean isAdminNeedsPermission() {
        return this.adminNeedsPermission;
    }

    public AnterosSecurityManager setAdminNeedsPermission(boolean adminNeedsPermission) throws Exception {
        this.adminNeedsPermission = adminNeedsPermission;
        return this;
    }
}

