/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.spring.ActionSecured;
import br.com.anteros.security.spring.AnterosSecurityGrantedAuthority;
import br.com.anteros.security.spring.AnterosSecurityUser;
import br.com.anteros.security.spring.ResourceSecured;
import java.lang.reflect.Method;
import java.util.Collection;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AnterosSecurityVoter
implements AccessDecisionVoter {
    private static final String EMPTY_SYSTEM = "no_system";
    private static final String EMPTY_RESOURCE = "no_resource";
    private static final String EMPTY_ACTION = "no_action";
    private String rolePrefix = "ACT_";

    public String getActionPrefix() {
        return this.rolePrefix;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public boolean supports(ConfigAttribute config) {
        return config.getAttribute() != null && config.getAttribute().startsWith(this.getActionPrefix());
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection attributes) {
        AnterosSecurityUser principal = (AnterosSecurityUser)authentication.getPrincipal();
        if (!principal.isAdminNeedsPermission()) {
            return 1;
        }
        int result = 0;
        Collection<? extends GrantedAuthority> authorities = this.extractAuthorities(authentication);
        for (Object attribute : attributes) {
            ConfigAttribute configAttribute = (ConfigAttribute)attribute;
            if (!this.supports(configAttribute)) continue;
            result = -1;
            String systemName = principal.getSystemName();
            String resourceName = EMPTY_RESOURCE;
            String actionName = configAttribute.getAttribute();
            boolean requiresAdmin = false;
            if (object instanceof ReflectiveMethodInvocation) {
                Method method = ((ReflectiveMethodInvocation)object).getMethod();
                Class<?> clazz = method.getDeclaringClass();
                if (clazz.isAnnotationPresent(ResourceSecured.class)) {
                    ResourceSecured annotation = clazz.getAnnotation(ResourceSecured.class);
                    resourceName = annotation.resourceName();
                }
                if (method.isAnnotationPresent(ActionSecured.class)) {
                    ActionSecured secured = method.getAnnotation(ActionSecured.class);
                    actionName = secured.actionName();
                    requiresAdmin = secured.requiresAdmin();
                }
            }
            if (EMPTY_SYSTEM.equals(systemName) || EMPTY_RESOURCE.equals(resourceName) || EMPTY_ACTION.equalsIgnoreCase(actionName)) {
                return -1;
            }
            if (requiresAdmin && !principal.isAdmin()) {
                return -1;
            }
            for (GrantedAuthority grantedAuthority : authorities) {
                if (!(grantedAuthority instanceof AnterosSecurityGrantedAuthority ? ((AnterosSecurityGrantedAuthority)grantedAuthority).equalsTo(systemName, resourceName, actionName) : ((SecurityConfig)attribute).getAttribute().equalsIgnoreCase(grantedAuthority.getAuthority()))) continue;
                return 1;
            }
        }
        return result;
    }

    Collection<? extends GrantedAuthority> extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }
}

