/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.model.Action;
import br.com.anteros.security.model.User;
import br.com.anteros.security.spring.AnterosSecurityGrantedAuthority;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AnterosSecurityUser
implements UserDetails {
    private static final long serialVersionUID = 1L;
    private String userName;
    private String password;
    private String systemName;
    private String version;
    private boolean adminNeedsPermission = true;
    private Set<AnterosSecurityGrantedAuthority> actions;
    private boolean accountExpired;
    private boolean accountLocked;
    private boolean accountInactive;
    private boolean admin;

    public AnterosSecurityUser(User user) {
        this.makeUser(user);
        user = null;
    }

    public AnterosSecurityUser(User user, String systemName) {
        this.systemName = systemName;
        this.makeUser(user);
        user = null;
    }

    private void makeUser(User user) {
        this.userName = user.getLogin();
        this.password = user.getSenha();
        this.accountExpired = user.isExpirada();
        this.accountInactive = user.getContaDesativada();
        this.accountLocked = user.getContaBloqueada();
        this.admin = user.getBoAdministrador();
        this.actions = new HashSet<AnterosSecurityGrantedAuthority>();
        for (Action action : user.getAcoes()) {
            if (this.systemName != null && !action.getRecurso().getSistema().getNome().equalsIgnoreCase(this.systemName)) continue;
            this.actions.add(new AnterosSecurityGrantedAuthority(action));
        }
        if (user.getPerfil() != null) {
            for (Action action : user.getPerfil().getAcoes()) {
                if (this.systemName != null && !action.getRecurso().getSistema().getNome().equalsIgnoreCase(this.systemName)) continue;
                this.actions.add(new AnterosSecurityGrantedAuthority(action));
            }
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.actions;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.userName;
    }

    public boolean isAccountNonExpired() {
        return !this.accountExpired;
    }

    public boolean isAccountNonLocked() {
        return !this.accountLocked;
    }

    public boolean isCredentialsNonExpired() {
        return !this.accountExpired;
    }

    public boolean isEnabled() {
        return !this.accountLocked && !this.accountInactive;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isAdminNeedsPermission() {
        return this.adminNeedsPermission;
    }

    public void setAdminNeedsPermission(boolean adminNeedsPermission) {
        this.adminNeedsPermission = adminNeedsPermission;
    }
}

