/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.model.Action;
import org.springframework.security.core.GrantedAuthority;

public class AnterosSecurityGrantedAuthority
implements GrantedAuthority {
    private static final long serialVersionUID = 1L;
    private String authoriy;
    private String systemName;
    private String resourceName;
    private String actionName;

    public AnterosSecurityGrantedAuthority(Action action) {
        this.makeAuthority(action);
    }

    private void makeAuthority(Action action) {
        this.authoriy = action.getNome();
        this.systemName = action.getRecurso().getSistema().getNome();
        this.resourceName = action.getRecurso().getNome();
        this.actionName = action.getNome();
    }

    public String getAuthority() {
        return this.authoriy;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public boolean equalsTo(String systemName, String resourceName, String actionName) {
        if (!systemName.equalsIgnoreCase(this.getSystemName())) {
            return false;
        }
        if (!resourceName.equalsIgnoreCase(this.getResourceName())) {
            return false;
        }
        return actionName.equalsIgnoreCase(this.getActionName());
    }
}

