/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.security.spring;

import br.com.anteros.security.spring.AnterosSecurityVoter;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAccessDecisionManager;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="anterosSecurityMethodAccessDecisionManager")
public class AnterosSecurityAccessDecisionManager
extends AbstractAccessDecisionManager {
    public void afterPropertiesSet() throws Exception {
        ArrayList<AnterosSecurityVoter> list = new ArrayList<AnterosSecurityVoter>();
        list.add(new AnterosSecurityVoter());
        this.setDecisionVoters(list);
        super.afterPropertiesSet();
    }

    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException {
        int deny = 0;
        for (AccessDecisionVoter voter : this.getDecisionVoters()) {
            int result = voter.vote(authentication, object, configAttributes);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Voter: " + voter + ", returned: " + result));
            }
            switch (result) {
                case 1: {
                    return;
                }
                case -1: {
                    ++deny;
                    break;
                }
            }
        }
        if (deny > 0) {
            throw new AccessDeniedException(this.messages.getMessage("AbstractAccessDecisionManager.accessDenied", "Access is denied"));
        }
        this.checkAllowIfAllAbstainDecisions();
    }
}

