/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.util;

import br.com.anteros.restdoc.maven.plugin.util.JavadocUtil;
import br.com.anteros.restdoc.maven.plugin.util.ProjectArtifactFilter;
import br.com.anteros.restdoc.maven.plugin.util.SourceResolverConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugins.javadoc.options.JavadocOptions;
import org.apache.maven.plugins.javadoc.options.io.xpp3.JavadocOptionsXpp3Reader;
import org.apache.maven.plugins.javadoc.resolver.JavadocBundle;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public final class ResourceResolver {
    public static final String SOURCES_CLASSIFIER = "sources";
    public static final String TEST_SOURCES_CLASSIFIER = "test-sources";
    private static final List<String> SOURCE_VALID_CLASSIFIERS = Arrays.asList("sources", "test-sources");
    private static final List<String> RESOURCE_VALID_CLASSIFIERS = Arrays.asList("javadoc-resources", "test-javadoc-resources");

    private ResourceResolver() {
    }

    public static List<JavadocBundle> resolveDependencyJavadocBundles(SourceResolverConfig config) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ResourceResolver.key(p.getGroupId(), p.getArtifactId()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        ArrayList<Artifact> forResourceResolution = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String key = ResourceResolver.key(artifact.getGroupId(), artifact.getArtifactId());
            MavenProject p = (MavenProject)projectMap.get(key);
            if (p != null) {
                bundles.addAll(ResourceResolver.resolveBundleFromProject(config, p, artifact));
                continue;
            }
            forResourceResolution.add(artifact);
        }
        bundles.addAll(ResourceResolver.resolveBundlesFromArtifacts(config, forResourceResolution));
        return bundles;
    }

    public static List<String> resolveDependencySourcePaths(SourceResolverConfig config) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<String> dirs = new ArrayList<String>();
        HashMap<String, MavenProject> projectMap = new HashMap<String, MavenProject>();
        if (config.reactorProjects() != null) {
            for (MavenProject p : config.reactorProjects()) {
                projectMap.put(ResourceResolver.key(p.getGroupId(), p.getArtifactId()), p);
            }
        }
        List artifacts = config.project().getTestArtifacts();
        ArrayList<Artifact> forResourceResolution = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            String key = ResourceResolver.key(artifact.getGroupId(), artifact.getArtifactId());
            MavenProject p = (MavenProject)projectMap.get(key);
            if (p != null) {
                dirs.addAll(ResourceResolver.resolveFromProject(config, p, artifact));
                continue;
            }
            forResourceResolution.add(artifact);
        }
        dirs.addAll(ResourceResolver.resolveFromArtifacts(config, forResourceResolution));
        return dirs;
    }

    private static List<JavadocBundle> resolveBundleFromProject(SourceResolverConfig config, MavenProject project, Artifact artifact) throws IOException {
        ArrayList<JavadocBundle> bundles = new ArrayList<JavadocBundle>();
        ArrayList<String> classifiers = new ArrayList<String>();
        if (config.includeCompileSources()) {
            classifiers.add("javadoc-resources");
        }
        if (config.includeTestSources()) {
            classifiers.add("test-javadoc-resources");
        }
        for (String classifier : classifiers) {
            File optionsFile = new File(project.getBuild().getDirectory(), "javadoc-bundle-options/javadoc-options-" + classifier + ".xml");
            if (!optionsFile.exists()) continue;
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(optionsFile);
                JavadocOptions options = new JavadocOptionsXpp3Reader().read((InputStream)stream);
                bundles.add(new JavadocBundle(options, new File(project.getBasedir(), options.getJavadocResourcesDirectory())));
            }
            catch (XmlPullParserException e) {
                try {
                    IOException error = new IOException("Failed to read javadoc options from: " + optionsFile + "\nReason: " + e.getMessage());
                    error.initCause(e);
                    throw error;
                }
                catch (Throwable throwable) {
                    IOUtil.close(stream);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)stream);
        }
        return bundles;
    }

    private static List<JavadocBundle> resolveBundlesFromArtifacts(SourceResolverConfig config, List<Artifact> artifacts) throws IOException {
        List<String> dirs;
        block13: {
            ArrayList<Artifact> toResolve = new ArrayList<Artifact>(artifacts.size());
            for (Artifact artifact : artifacts) {
                if (config.filter() != null && !config.filter().include(artifact)) continue;
                if (config.includeCompileSources()) {
                    toResolve.add(ResourceResolver.createResourceArtifact(artifact, "javadoc-resources", config));
                }
                if (!config.includeTestSources()) continue;
                toResolve.add(ResourceResolver.createResourceArtifact(artifact, "test-javadoc-resources", config));
            }
            dirs = null;
            try {
                dirs = ResourceResolver.resolveAndUnpack(toResolve, config, RESOURCE_VALID_CLASSIFIERS, false);
            }
            catch (ArtifactResolutionException e) {
                if (config.log().isDebugEnabled()) {
                    config.log().debug((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
            catch (ArtifactNotFoundException e) {
                if (!config.log().isDebugEnabled()) break block13;
                config.log().debug((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        ArrayList<JavadocBundle> result = new ArrayList<JavadocBundle>();
        if (dirs != null) {
            for (String d : dirs) {
                File dir = new File(d);
                File resources = new File(dir, "resources");
                JavadocOptions options = null;
                File javadocOptions = new File(dir, "META-INF/maven/javadoc-options.xml");
                if (javadocOptions.exists()) {
                    FileInputStream reader = null;
                    try {
                        reader = new FileInputStream(javadocOptions);
                        options = new JavadocOptionsXpp3Reader().read((InputStream)reader);
                    }
                    catch (XmlPullParserException e) {
                        try {
                            IOException error = new IOException("Failed to parse javadoc options: " + e.getMessage());
                            error.initCause(e);
                            throw error;
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(reader);
                            throw throwable;
                        }
                    }
                    IOUtil.close((InputStream)reader);
                }
                result.add(new JavadocBundle(options, resources));
            }
        }
        return result;
    }

    private static List<String> resolveFromArtifacts(SourceResolverConfig config, List<Artifact> artifacts) throws ArtifactResolutionException, ArtifactNotFoundException {
        ArrayList<Artifact> toResolve = new ArrayList<Artifact>(artifacts.size());
        for (Artifact artifact : artifacts) {
            if (config.filter() != null && !config.filter().include(artifact)) continue;
            if (config.includeCompileSources()) {
                toResolve.add(ResourceResolver.createResourceArtifact(artifact, SOURCES_CLASSIFIER, config));
            }
            if (!config.includeTestSources()) continue;
            toResolve.add(ResourceResolver.createResourceArtifact(artifact, TEST_SOURCES_CLASSIFIER, config));
        }
        return ResourceResolver.resolveAndUnpack(toResolve, config, SOURCE_VALID_CLASSIFIERS, true);
    }

    private static Artifact createResourceArtifact(Artifact artifact, String classifier, SourceResolverConfig config) {
        DefaultArtifact a = (DefaultArtifact)config.artifactFactory().createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", classifier);
        a.setRepository(artifact.getRepository());
        return a;
    }

    private static List<String> resolveAndUnpack(List<Artifact> artifacts, SourceResolverConfig config, List<String> validClassifiers, boolean propagateErrors) throws ArtifactResolutionException, ArtifactNotFoundException {
        LinkedHashSet<Artifact> artifactSet = new LinkedHashSet<Artifact>(artifacts);
        Artifact pomArtifact = config.project().getArtifact();
        ArtifactRepository localRepo = config.localRepository();
        List remoteRepos = config.project().getRemoteArtifactRepositories();
        ArtifactMetadataSource metadataSource = config.artifactMetadataSource();
        ArtifactFilter filter = config.filter();
        ProjectArtifactFilter resolutionFilter = null;
        if (filter != null) {
            resolutionFilter = new ProjectArtifactFilter(pomArtifact, filter);
        }
        ArtifactResolver resolver = config.artifactResolver();
        Map managed = config.project().getManagedVersionMap();
        ArtifactResolutionResult resolutionResult = resolver.resolveTransitively(artifactSet, pomArtifact, managed, localRepo, remoteRepos, metadataSource, (ArtifactFilter)resolutionFilter);
        ArrayList<String> result = new ArrayList<String>(artifacts.size());
        for (Artifact a : resolutionResult.getArtifacts()) {
            if (!validClassifiers.contains(a.getClassifier()) || filter != null && !filter.include(a)) continue;
            File d = new File(config.outputBasedir(), a.getArtifactId() + "-" + a.getVersion() + "-" + a.getClassifier());
            if (!d.exists()) {
                d.mkdirs();
            }
            try {
                UnArchiver unArchiver = config.archiverManager().getUnArchiver(a.getType());
                unArchiver.setDestDirectory(d);
                unArchiver.setSourceFile(a.getFile());
                unArchiver.extract();
                result.add(d.getAbsolutePath());
            }
            catch (NoSuchArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to retrieve valid un-archiver component: " + a.getType(), a, (Throwable)e);
            }
            catch (ArchiverException e) {
                if (!propagateErrors) continue;
                throw new ArtifactResolutionException("Failed to unpack: " + a.getId(), a, (Throwable)e);
            }
        }
        return result;
    }

    private static List<String> resolveFromProject(SourceResolverConfig config, MavenProject reactorProject, Artifact artifact) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (config.filter() == null || config.filter().include(artifact)) {
            List srcRoots;
            if (config.includeCompileSources()) {
                srcRoots = reactorProject.getCompileSourceRoots();
                for (String root : srcRoots) {
                    dirs.add(root);
                }
            }
            if (config.includeTestSources()) {
                srcRoots = reactorProject.getTestCompileSourceRoots();
                for (String root : srcRoots) {
                    dirs.add(root);
                }
            }
        }
        return JavadocUtil.pruneDirs(reactorProject, dirs);
    }

    private static String key(String gid, String aid) {
        return gid + ":" + aid;
    }
}

