/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.doclet.collector.jaxrs;

import br.com.anteros.restdoc.maven.plugin.doclet.collector.AbstractCollector;
import br.com.anteros.restdoc.maven.plugin.doclet.collector.EndpointMapping;
import br.com.anteros.restdoc.maven.plugin.doclet.model.PathVar;
import br.com.anteros.restdoc.maven.plugin.doclet.model.QueryParam;
import br.com.anteros.restdoc.maven.plugin.doclet.model.RequestBody;
import br.com.anteros.restdoc.maven.plugin.util.AnnotationUtils;
import br.com.anteros.restdoc.maven.plugin.util.CommonUtils;
import br.com.anteros.restdoc.maven.plugin.util.TagUtils;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;

public class JaxRSCollector
extends AbstractCollector {
    protected static final String ANNOTATION_PACKAGE = "javax.ws.rs.";
    protected static final String PATH_ANNOTATION = "javax.ws.rs.Path";
    protected static final String GET_ANNOTATION = "javax.ws.rs.GET";
    protected static final String POST_ANNOTATION = "javax.ws.rs.POST";
    protected static final String PUT_ANNOTATION = "javax.ws.rs.PUT";
    protected static final String DELETE_ANNOTATION = "javax.ws.rs.DELETE";
    protected static final String HEAD_ANNOTATION = "javax.ws.rs.HEAD";
    protected static final String CONSUMES_ANNOTATION = "javax.ws.rs.Consumes";
    protected static final String PRODUCES_ANNOTATION = "javax.ws.rs.Produces";
    protected static final String PATHVAR_ANNOTATION = "javax.ws.rs.PathParam";
    protected static final String PARAM_ANNOTATION = "javax.ws.rs.QueryParam";

    @Override
    protected boolean shouldIgnoreClass(ClassDoc classDoc) {
        for (AnnotationDesc annotationDesc : classDoc.annotations()) {
            String annotationName = AnnotationUtils.getAnnotationName(annotationDesc);
            if (annotationName == null || !annotationName.startsWith(ANNOTATION_PACKAGE)) continue;
            return false;
        }
        for (AnnotationDesc annotationDesc : classDoc.methods(true)) {
            if (this.shouldIgnoreMethod((MethodDoc)annotationDesc)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldIgnoreMethod(MethodDoc methodDoc) {
        for (AnnotationDesc methodAnnotation : methodDoc.annotations()) {
            String annotationName = AnnotationUtils.getAnnotationName(methodAnnotation);
            if (!GET_ANNOTATION.equals(annotationName) && !POST_ANNOTATION.equals(annotationName) && !PUT_ANNOTATION.equals(annotationName) && !DELETE_ANNOTATION.equals(annotationName) && !HEAD_ANNOTATION.equals(annotationName)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EndpointMapping getEndpointMapping(ProgramElementDoc doc) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        LinkedHashSet<String> httpMethods = new LinkedHashSet<String>();
        LinkedHashSet<String> consumes = new LinkedHashSet<String>();
        LinkedHashSet<String> produces = new LinkedHashSet<String>();
        for (AnnotationDesc annotation : doc.annotations()) {
            String annotationName = AnnotationUtils.getAnnotationName(annotation);
            if (GET_ANNOTATION.equals(annotationName) || POST_ANNOTATION.equals(annotationName) || PUT_ANNOTATION.equals(annotationName) || DELETE_ANNOTATION.equals(annotationName) || HEAD_ANNOTATION.equals(annotationName)) {
                httpMethods.add(annotationName.replace(ANNOTATION_PACKAGE, ""));
                continue;
            }
            if (PATH_ANNOTATION.equals(annotationName)) {
                paths.addAll(AnnotationUtils.getElementValue(annotation, "value"));
                continue;
            }
            if (CONSUMES_ANNOTATION.equals(annotationName)) {
                consumes.addAll(AnnotationUtils.getElementValue(annotation, "value"));
                continue;
            }
            if (!PRODUCES_ANNOTATION.equals(annotationName)) continue;
            produces.addAll(AnnotationUtils.getElementValue(annotation, "value"));
        }
        return new EndpointMapping(paths, httpMethods, consumes, produces);
    }

    @Override
    protected Collection<PathVar> generatePathVars(MethodDoc methodDoc) {
        ArrayList<PathVar> retVal = new ArrayList<PathVar>();
        Tag[] tags = methodDoc.tags("pathVar");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            for (AnnotationDesc annotation : parameter.annotations()) {
                String text;
                if (!AnnotationUtils.getAnnotationName(annotation).equals(PATHVAR_ANNOTATION)) continue;
                String name = parameter.name();
                List<String> values = AnnotationUtils.getElementValue(annotation, "value");
                if (!values.isEmpty()) {
                    name = values.get(0);
                }
                if ((text = TagUtils.findParamText(tags, name)) == null) {
                    text = TagUtils.findParamText(paramTags, parameter.name());
                }
                if (text == null) {
                    text = "";
                }
                retVal.add(new PathVar(name, text, parameter.type().qualifiedTypeName()));
            }
        }
        return retVal;
    }

    @Override
    protected Collection<QueryParam> generateQueryParams(MethodDoc methodDoc) {
        ArrayList<QueryParam> retVal = new ArrayList<QueryParam>();
        Tag[] tags = methodDoc.tags("queryParam");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            for (AnnotationDesc annotation : parameter.annotations()) {
                String text;
                if (!AnnotationUtils.getAnnotationName(annotation).equals(PARAM_ANNOTATION)) continue;
                String name = parameter.name();
                List<String> values = AnnotationUtils.getElementValue(annotation, "value");
                if (!values.isEmpty()) {
                    name = values.get(0);
                }
                if ((text = TagUtils.findParamText(tags, name)) == null) {
                    text = TagUtils.findParamText(paramTags, parameter.name());
                }
                if (text == null) {
                    text = "";
                }
                retVal.add(new QueryParam(name, false, text, parameter.type().qualifiedTypeName()));
            }
        }
        return retVal;
    }

    @Override
    protected RequestBody generateRequestBody(MethodDoc methodDoc) {
        Tag[] tags = methodDoc.tags("requestBody");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            String text;
            if (!CommonUtils.isEmpty(parameter.annotations()) || parameter.typeName().startsWith("javax.")) continue;
            String string = text = CommonUtils.isEmpty(tags) ? null : tags[0].text();
            if (text == null) {
                text = TagUtils.findParamText(paramTags, parameter.name());
            }
            if (text == null) {
                text = "";
            }
            return new RequestBody(parameter.name(), text, parameter.type().qualifiedTypeName());
        }
        return null;
    }

    @Override
    protected Collection<String> resolveHttpMethods(EndpointMapping classMapping, EndpointMapping methodMapping) {
        return methodMapping.getHttpMethods();
    }
}

