/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.doclet;

import br.com.anteros.restdoc.maven.plugin.doclet.collector.Collector;
import br.com.anteros.restdoc.maven.plugin.doclet.collector.jaxrs.JaxRSCollector;
import br.com.anteros.restdoc.maven.plugin.doclet.collector.spring.SpringCollector;
import br.com.anteros.restdoc.maven.plugin.doclet.model.ClassDescriptor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.javadoc.Doclet;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class AnterosRestDoclet
extends Doclet {
    private static final Collection<Collector> collectors = Arrays.asList(new SpringCollector(), new JaxRSCollector());

    public static boolean start(RootDoc root) {
        String jsonTempFile = "";
        String[][] options = root.options();
        StringBuilder sourcePath = new StringBuilder();
        for (String[] option : options) {
            if (!option[0].equals("-sourcepath")) continue;
            sourcePath.append(option[1]);
            String[] split = option[1].split(File.pathSeparator);
            jsonTempFile = split[split.length - 1];
            String tmp = ":" + jsonTempFile;
            sourcePath.delete(option[1].indexOf(tmp), option[1].indexOf(tmp) + tmp.length());
            break;
        }
        File directory = new File(jsonTempFile);
        directory.mkdirs();
        jsonTempFile = jsonTempFile + File.separator + "anteros.json";
        ArrayList<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>();
        for (Collector collector : collectors) {
            classDescriptors.addAll(collector.getDescriptors(root));
        }
        if (classDescriptors.isEmpty()) {
            throw new DocletAbortException("N\u00e3o foram encontradas classes contendo documenta\u00e7\u00e3o no path " + sourcePath);
        }
        Collections.sort(classDescriptors, new Comparator<ClassDescriptor>(){

            @Override
            public int compare(ClassDescriptor o1, ClassDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ObjectMapper mapper = new ObjectMapper();
        try {
            File file = new File(jsonTempFile);
            FileOutputStream fos = new FileOutputStream(file);
            mapper.writeValue((OutputStream)fos, (Object)classDescriptors.toArray(new ClassDescriptor[0]));
            fos.flush();
            fos.close();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

