/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin;

import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.restdoc.maven.plugin.doclet.AnterosFreeMarkerTemplateLoader;
import br.com.anteros.restdoc.maven.plugin.doclet.AnterosRestDoclet;
import br.com.anteros.restdoc.maven.plugin.doclet.model.ClassDescriptor;
import br.com.anteros.restdoc.maven.plugin.doclet.model.Endpoint;
import br.com.anteros.restdoc.maven.plugin.doclet.model.PathVar;
import br.com.anteros.restdoc.maven.plugin.doclet.model.QueryParam;
import br.com.anteros.restdoc.maven.plugin.util.Curl;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class SnippetGenerator {
    private SnippetGenerator() {
    }

    public static void generate(String baseUrl, Writer w, ClassDescriptor ... classDescriptors) throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException, TemplateException {
        Configuration configuration = new Configuration();
        configuration.setTemplateLoader((TemplateLoader)new AnterosFreeMarkerTemplateLoader(AnterosRestDoclet.class, "/"));
        for (ClassDescriptor cld : classDescriptors) {
            Template template = configuration.getTemplate("template_resource.ftl");
            HashMap<String, String> dataModel = new HashMap<String, String>();
            dataModel.put("resourceName", cld.getName());
            dataModel.put("resourceDescription", cld.getDescription());
            template.process(dataModel, w);
            w.flush();
            for (Endpoint endpoint : cld.getEndpoints()) {
                StringWriter sw;
                HashMap<String, String> dataModelItem;
                Template itemTemplate;
                template = configuration.getTemplate("template_endpoint.ftl");
                dataModel = new HashMap();
                String newDescription = endpoint.getDescription().replaceAll("(\\r|\\n)", "");
                dataModel.put("endpointDescription", StringUtils.isEmpty((String)newDescription) ? "<N\u00e3o informado>" : newDescription);
                dataModel.put("httpMethod", endpoint.getHttpMethod().toUpperCase());
                dataModel.put("urlMapping", endpoint.getPath());
                template.process(dataModel, w);
                w.flush();
                if (!endpoint.getPathVars().isEmpty()) {
                    itemTemplate = configuration.getTemplate("template_path_parameters_item.ftl");
                    StringBuilder pathVariable = new StringBuilder();
                    for (PathVar pVar : endpoint.getPathVars()) {
                        dataModelItem = new HashMap<String, String>();
                        sw = new StringWriter();
                        dataModelItem.put("parameterName", pVar.getName());
                        dataModelItem.put("parameterType", pVar.getSimpleType());
                        dataModelItem.put("parameterDescription", StringUtils.isEmpty((String)pVar.getDescription()) ? "<Nulo>" : pVar.getDescription());
                        itemTemplate.process(dataModelItem, (Writer)sw);
                        sw.flush();
                        pathVariable.append(sw.toString()).append("\n");
                        sw.close();
                    }
                    template = configuration.getTemplate("template_path_parameters.ftl");
                    dataModel = new HashMap();
                    dataModel.put("pathParametersItem", pathVariable.toString());
                    template.process(dataModel, w);
                }
                if (!endpoint.getQueryParams().isEmpty()) {
                    itemTemplate = configuration.getTemplate("template_query_parameters_item.ftl");
                    StringBuilder queryVariable = new StringBuilder();
                    for (QueryParam pQueryParam : endpoint.getQueryParams()) {
                        dataModelItem = new HashMap();
                        sw = new StringWriter();
                        dataModelItem.put("parameterName", pQueryParam.getName());
                        dataModelItem.put("parameterType", pQueryParam.getSimpleType());
                        dataModelItem.put("parameterOptional", pQueryParam.isRequired() ? "False" : "True");
                        dataModelItem.put("parameterDescription", StringUtils.isEmpty((String)pQueryParam.getDescription()) ? "<Nulo>" : pQueryParam.getDescription());
                        itemTemplate.process(dataModelItem, (Writer)sw);
                        sw.flush();
                        queryVariable.append(sw.toString()).append("\n");
                        sw.close();
                    }
                    template = configuration.getTemplate("template_query_parameters.ftl");
                    dataModel = new HashMap();
                    dataModel.put("queryParametersItem", queryVariable.toString());
                    template.process(dataModel, w);
                }
                if (endpoint.getRequestBody() != null) {
                    template = configuration.getTemplate("template_request_body.ftl");
                    dataModel = new HashMap();
                    dataModel.put("parameterName", endpoint.getRequestBody().getName());
                    dataModel.put("parameterType", endpoint.getRequestBody().getSimpleType());
                    dataModel.put("parameterDescription", endpoint.getRequestBody().getDescription());
                    template.process(dataModel, w);
                }
                Curl curl = Curl.of(baseUrl).endPoint(endpoint.getPath()).basicAuthentication("<USER>", "<PASSWORD>").enableResponseLogging().timeOut(300L).type(Curl.Type.valueOf(endpoint.getHttpMethod().toUpperCase()));
                if (!endpoint.getQueryParams().isEmpty()) {
                    for (QueryParam qp : endpoint.getQueryParams()) {
                        curl.parameter(qp.getName(), "{" + qp.getName() + "}");
                    }
                }
                if (endpoint.getRequestBody() != null) {
                    curl.body("{" + endpoint.getRequestBody().getName() + "}");
                }
                template = configuration.getTemplate("template_request_example.ftl");
                dataModel = new HashMap();
                dataModel.put("curl", curl.toCurl());
                dataModel.put("http_url", curl.toUrl().replace("\"", ""));
                template.process(dataModel, w);
            }
        }
    }
}

