/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin;

import br.com.anteros.core.utils.IOUtils;
import br.com.anteros.core.utils.ResourceUtils;
import br.com.anteros.restdoc.maven.plugin.SnippetGenerator;
import br.com.anteros.restdoc.maven.plugin.doclet.AnterosRestDoclet;
import br.com.anteros.restdoc.maven.plugin.doclet.model.ClassDescriptor;
import br.com.anteros.restdoc.maven.plugin.util.JavadocUtil;
import br.com.anteros.restdoc.maven.plugin.util.ResourceResolver;
import br.com.anteros.restdoc.maven.plugin.util.SourceResolverConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.IncludesArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.asciidoctor.maven.AsciidoctorMojo;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE)
public class AnterosRestDocMojo
extends AsciidoctorMojo {
    @Parameter(defaultValue="${project.build.directory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project}")
    private MavenProject project = null;
    @Parameter(defaultValue="${project.name}", required=true)
    private String projectDisplayName;
    @Parameter(defaultValue="${project.compileSourceRoots}")
    private List<String> compileSourceRoots;
    @Parameter(defaultValue="${project.compileClasspathElements}")
    private List<String> classpathElements;
    @Parameter(required=true)
    private List<String> packageScanEndpoints = new ArrayList<String>();
    @Parameter(required=true)
    private String urlBase;
    @Parameter(defaultValue="false")
    private boolean includeDependencySources;
    @Parameter(defaultValue="${project.build.directory}/distro-javadoc-sources")
    private File sourceDependencyCacheDir;
    @Parameter
    private List<String> dependencySourceIncludes;
    @Parameter
    private List<String> dependencySourceExcludes;
    @Parameter(property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(property="project.remoteArtifactRepositories")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="false")
    private boolean includeTransitiveDependencySources;
    @Component
    private ArchiverManager archiverManager;
    @Component
    private ArtifactFactory factory;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private ArtifactResolver resolver;
    @Parameter(property="reactorProjects", readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sourceDocumentName == null) {
            this.sourceDocumentName = "index.adoc";
            try {
                InputStream openStream = ResourceUtils.getResourceAsStream((String)"template_index.adoc");
                if (!this.sourceDirectory.exists()) {
                    this.sourceDirectory.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(new File(this.sourceDirectory + File.separator + this.sourceDocumentName));
                IOUtils.copy((InputStream)openStream, (OutputStream)fos);
                fos.flush();
                fos.close();
                openStream.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException("N\u00e3o foi informado o nome do documento principal para gerar a documenta\u00e7\u00e3o e n\u00e3o foi encontrado o padr\u00e3o.", (Exception)e);
            }
        }
        List<String> dependencySourcePaths = null;
        if (this.includeDependencySources) {
            try {
                dependencySourcePaths = this.getDependencySourcePaths();
            }
            catch (MavenReportException e1) {
                throw new MojoExecutionException("Ocorreu um erro obtendo source code das depend\u00eancias.", (Exception)((Object)e1));
            }
        }
        String temporaryDirectoryJson = this.rootDir + File.separator + "target" + File.separator + "anteros-jsonc-javadoc";
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-protected");
        parameters.add("-sourcepath");
        StringBuilder sbSourcesPath = new StringBuilder();
        sbSourcesPath.append((CharSequence)this.getSourcesPath());
        if (dependencySourcePaths != null) {
            for (String ds : dependencySourcePaths) {
                sbSourcesPath.append(File.pathSeparator);
                sbSourcesPath.append(ds);
            }
        }
        sbSourcesPath.append(File.pathSeparator).append(temporaryDirectoryJson);
        parameters.add(sbSourcesPath.toString());
        if (this.packageScanEndpoints != null) {
            for (String p : this.packageScanEndpoints) {
                if (p.contains("*")) {
                    throw new MojoExecutionException("Pacotes n\u00e3o podem conter asteriscos(*) no nome " + p);
                }
                parameters.add(p);
            }
        }
        parameters.add("br.com.anteros.springWeb.controller");
        parameters.add("-doclet");
        parameters.add(AnterosRestDoclet.class.getName());
        parameters.add("-classpath");
        parameters.add(this.getClassPath());
        Main.execute((String[])parameters.toArray(new String[0]));
        File temporaryJsonPath = new File(temporaryDirectoryJson);
        if (!temporaryJsonPath.exists()) {
            temporaryJsonPath.mkdirs();
        }
        File file = new File(temporaryJsonPath + File.separator + "anteros.json");
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectMapper mapper = new ObjectMapper();
            ClassDescriptor[] classDescriptors = (ClassDescriptor[])mapper.readValue((InputStream)fis, ClassDescriptor[].class);
            String filePath = "";
            if (this.sourceDirectory != null) {
                filePath = this.sourceDirectory.getAbsolutePath();
            } else if (this.sourceDocumentName != null) {
                filePath = this.sourceDocumentName.substring(0, this.sourceDocumentName.lastIndexOf(File.separator));
            }
            File itemsFile = new File(filePath, "items.adoc");
            FileWriter writer = new FileWriter(itemsFile);
            SnippetGenerator.generate(this.urlBase, writer, classDescriptors);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            fis.close();
            if (!this.attributes.containsKey("stylesheet")) {
                File stylesheetFile = new File(filePath, "asciidoc_stylesheet.css");
                try {
                    InputStream openStream = ResourceUtils.getResourceAsStream((String)"asciidoc_stylesheet.css");
                    FileOutputStream fos = new FileOutputStream(stylesheetFile);
                    IOUtils.copy((InputStream)openStream, (OutputStream)fos);
                    fos.flush();
                    fos.close();
                    openStream.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("N\u00e3o foi poss\u00edvel copiar o template padr\u00e3o de CSS.", (Exception)e);
                }
                this.attributes.put("stylesheet", stylesheetFile.getAbsolutePath());
            }
            super.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("N\u00e3o foi poss\u00edvel gerar a documenta\u00e7\u00e3o da API Rest.", e);
        }
    }

    protected StringBuilder getSourcesPath() {
        StringBuilder classPath = new StringBuilder();
        boolean appendDelimiter = false;
        for (String s : this.compileSourceRoots) {
            if (appendDelimiter) {
                classPath.append(":");
            }
            classPath.append(s);
            appendDelimiter = true;
        }
        return classPath;
    }

    protected String getClassPath() {
        StringBuilder classPath = new StringBuilder();
        boolean appendDelimiter = false;
        for (String s : this.classpathElements) {
            if (appendDelimiter) {
                classPath.append(":");
            }
            classPath.append(s);
            appendDelimiter = true;
        }
        return classPath.toString();
    }

    public List<String> getPackageScanEndpoints() {
        return this.packageScanEndpoints;
    }

    protected final List<String> getDependencySourcePaths() throws MavenReportException {
        try {
            if (this.sourceDependencyCacheDir.exists()) {
                FileUtils.forceDelete((File)this.sourceDependencyCacheDir);
                this.sourceDependencyCacheDir.mkdirs();
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Failed to delete cache directory: " + this.sourceDependencyCacheDir + "\nReason: " + e.getMessage(), (Exception)e);
        }
        SourceResolverConfig config = this.getDependencySourceResolverConfig();
        AndArtifactFilter andFilter = new AndArtifactFilter();
        List<String> dependencyIncludes = this.dependencySourceIncludes;
        List<String> dependencyExcludes = this.dependencySourceExcludes;
        if (!this.includeTransitiveDependencySources || JavadocUtil.isNotEmpty(dependencyIncludes) || JavadocUtil.isNotEmpty(dependencyExcludes)) {
            if (!this.includeTransitiveDependencySources) {
                andFilter.add(this.createDependencyArtifactFilter());
            }
            if (JavadocUtil.isNotEmpty(dependencyIncludes)) {
                andFilter.add((ArtifactFilter)new PatternIncludesArtifactFilter(dependencyIncludes, false));
            }
            if (JavadocUtil.isNotEmpty(dependencyExcludes)) {
                andFilter.add((ArtifactFilter)new PatternExcludesArtifactFilter(dependencyExcludes, false));
            }
            config.withFilter((ArtifactFilter)andFilter);
        }
        try {
            return ResourceResolver.resolveDependencySourcePaths(config);
        }
        catch (ArtifactResolutionException e) {
            throw new MavenReportException("Failed to resolve one or more javadoc source/resource artifacts:\n\n" + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MavenReportException("Failed to resolve one or more javadoc source/resource artifacts:\n\n" + e.getMessage(), (Exception)((Object)e));
        }
    }

    private SourceResolverConfig getDependencySourceResolverConfig() {
        return this.configureDependencySourceResolution(new SourceResolverConfig(this.getLog(), this.project, this.localRepository, this.sourceDependencyCacheDir, this.resolver, this.factory, this.artifactMetadataSource, this.archiverManager).withReactorProjects(this.reactorProjects));
    }

    protected SourceResolverConfig configureDependencySourceResolution(SourceResolverConfig config) {
        return config.withCompileSources();
    }

    private ArtifactFilter createDependencyArtifactFilter() {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        ArrayList<String> artifactPatterns = new ArrayList<String>(dependencyArtifacts.size());
        for (Artifact artifact : dependencyArtifacts) {
            artifactPatterns.add(artifact.getGroupId() + ":" + artifact.getArtifactId());
        }
        return new IncludesArtifactFilter(artifactPatterns);
    }
}

