/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.util;

import br.com.anteros.core.utils.StringUtils;
import java.util.HashMap;
import java.util.Locale;

public class Curl {
    private final String mUrl;
    private final HashMap<String, String> mHeaders = new HashMap();
    private final HashMap<String, Object> mParameters = new HashMap();
    private final HashMap<String, Object> mCookies = new HashMap();
    private static final String FORMATTED_HEADER = "-H \"%s: %s\" ";
    private static final String FORMATTED_URL = "\"%s\" ";
    private static final String FORMATTED_PARM = "%s=%s&";
    private boolean responseLogging = false;
    private boolean verbose = false;
    private String basicAuthentication = null;
    private Type mType = Type.GET;
    private long mTimeOut = 30000L;
    private String endPoint;
    private String body;

    public static Curl of(String mUrl) {
        return new Curl(mUrl);
    }

    private Curl(String mUrl) {
        this.mUrl = mUrl;
    }

    public Curl type(Type t) {
        this.mType = t;
        return this;
    }

    public Curl header(String k, String v) {
        this.mHeaders.put(k, v);
        return this;
    }

    public Curl headers(HashMap<String, String> hs) {
        if (hs != null && hs.size() > 0) {
            this.mHeaders.putAll(hs);
        }
        return this;
    }

    public Curl body(String body) {
        this.body = body;
        return this;
    }

    public Curl parameter(String k, Object v) {
        this.mParameters.put(k, v);
        return this;
    }

    public Curl parameters(HashMap<String, Object> ps) {
        if (ps != null && ps.size() > 0) {
            this.mParameters.putAll(ps);
        }
        return this;
    }

    public Curl cookie(String k, Object v) {
        this.mCookies.put(k, v);
        return this;
    }

    public Curl cookies(HashMap<String, Object> cs) {
        if (cs != null && cs.size() > 0) {
            this.mCookies.putAll(cs);
        }
        return this;
    }

    public Curl timeOut(long mTimeOut) {
        this.mTimeOut = mTimeOut;
        return this;
    }

    public Curl enableResponseLogging() {
        this.responseLogging = true;
        return this;
    }

    public Curl enableVerbose() {
        this.verbose = true;
        return this;
    }

    public Curl basicAuthentication(String username, String password) {
        this.basicAuthentication = username + ":" + password;
        return this;
    }

    public Curl basicAuthentication(String auth) {
        this.basicAuthentication = auth;
        return this;
    }

    public String toCurl() {
        StringBuilder builder = new StringBuilder();
        builder.append("curl ");
        this.addTimeOut(builder);
        this.addHeaders(builder);
        this.addCookies(builder);
        this.addExtraParms(builder);
        this.addType(builder);
        this.addUrlAndParameters(builder);
        this.addBody(builder);
        return builder.toString();
    }

    public String toUrl() {
        StringBuilder builder = new StringBuilder();
        this.addUrlAndParameters(builder);
        return builder.toString();
    }

    private void addBody(StringBuilder builder) {
        if (StringUtils.isNotEmpty((String)this.body)) {
            builder.append("-d \"");
            builder.append(this.body);
            builder.append("\" ");
        }
    }

    private void addHeaders(StringBuilder builder) {
        if (!this.mHeaders.isEmpty()) {
            for (String key : this.mHeaders.keySet()) {
                builder.append(String.format(Locale.US, FORMATTED_HEADER, key, this.mHeaders.get(key)));
            }
        }
    }

    private void addCookies(StringBuilder builder) {
        if (this.mCookies.size() > 0) {
            builder.append("-c \"");
            for (String key : this.mCookies.keySet()) {
                builder.append(String.format(Locale.US, FORMATTED_PARM, key, this.mCookies.get(key).toString()));
            }
            builder.deleteCharAt(builder.length() - 1).append("\" ");
        }
    }

    private void addExtraParms(StringBuilder builder) {
        if (this.responseLogging) {
            builder.append("-i ");
        }
        if (this.verbose) {
            builder.append("-v ");
        }
        if (this.basicAuthentication != null) {
            builder.append("-u ").append(this.basicAuthentication).append(" ");
        }
    }

    private void addType(StringBuilder builder) {
        builder.append("-X ").append(this.mType.name).append(' ');
    }

    private void addUrlAndParameters(StringBuilder builder) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(this.mUrl).append(this.endPoint == null ? "" : this.endPoint);
        if (!this.mParameters.isEmpty()) {
            tmp.append("?");
            for (String key : this.mParameters.keySet()) {
                tmp.append(String.format(Locale.US, FORMATTED_PARM, key, this.mParameters.get(key).toString()));
            }
            tmp.deleteCharAt(tmp.length() - 1);
        }
        builder.append(String.format(Locale.US, FORMATTED_URL, tmp.toString()));
    }

    private void addTimeOut(StringBuilder builder) {
        if (this.mTimeOut != 30000L) {
            builder.append("--max-time ").append(this.mTimeOut).append(" ");
        }
    }

    public Curl endPoint(String endPoint) {
        this.endPoint = endPoint;
        return this;
    }

    public static enum Type {
        GET("GET"),
        POST("POST"),
        DELETE("DELETE"),
        PUT("PUT");

        public final String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

