/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;

public class CommonUtils {
    public static <T> boolean isEmpty(T[] items) {
        return items == null || items.length == 0;
    }

    public static <T> boolean isEmpty(Collection<T> items) {
        return items == null || items.isEmpty();
    }

    public static boolean isEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (CommonUtils.isEmpty(closeables)) {
            return;
        }
        Exception first = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception e) {
                first = first == null ? e : first;
            }
        }
        if (first != null) {
            throw first instanceof IOException ? (IOException)first : new IOException(first);
        }
    }

    public static <T> Collection<T> firstNonEmpty(Collection<T> ... collections) {
        for (Collection<T> collection : collections) {
            if (CommonUtils.isEmpty(collection)) continue;
            return collection;
        }
        return Collections.emptySet();
    }

    public static void copy(InputStream input, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = input.read(buffer)) > 0) {
            output.write(buffer, 0, len);
        }
    }

    public static String fixPath(String path) {
        if (CommonUtils.isEmpty(path)) {
            return "/";
        }
        int len = 0;
        while (path.length() != len) {
            len = path.length();
            path = path.replaceAll("//", "/");
        }
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

