/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.util;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationUtils {
    public static String getAnnotationName(AnnotationDesc annotation) {
        try {
            return annotation.annotationType().qualifiedName();
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static List<String> getElementValue(AnnotationDesc annotation, String key) {
        for (AnnotationDesc.ElementValuePair element : annotation.elementValues()) {
            if (!element.element().name().equals(key)) continue;
            return AnnotationUtils.resolveAnnotationValue(element.value());
        }
        return Collections.emptyList();
    }

    private static List<String> resolveAnnotationValue(AnnotationValue value) {
        ArrayList<String> retVal = new ArrayList<String>();
        if (value.value() instanceof AnnotationValue[]) {
            for (AnnotationValue annotationValue : (AnnotationValue[])value.value()) {
                retVal.addAll(AnnotationUtils.resolveAnnotationValue(annotationValue));
            }
        } else {
            retVal.add(value.value().toString());
        }
        return retVal;
    }
}

