/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.restdoc.maven.plugin.doclet.collector.spring;

import br.com.anteros.restdoc.maven.plugin.doclet.collector.AbstractCollector;
import br.com.anteros.restdoc.maven.plugin.doclet.collector.EndpointMapping;
import br.com.anteros.restdoc.maven.plugin.doclet.model.PathVar;
import br.com.anteros.restdoc.maven.plugin.doclet.model.QueryParam;
import br.com.anteros.restdoc.maven.plugin.doclet.model.RequestBody;
import br.com.anteros.restdoc.maven.plugin.util.AnnotationUtils;
import br.com.anteros.restdoc.maven.plugin.util.CommonUtils;
import br.com.anteros.restdoc.maven.plugin.util.TagUtils;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class SpringCollector
extends AbstractCollector {
    protected static final List<String> CONTROLLER_ANNOTATION = Arrays.asList("org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController");
    protected static final String MAPPING_ANNOTATION = "org.springframework.web.bind.annotation.RequestMapping";
    protected static final String PATHVAR_ANNOTATION = "org.springframework.web.bind.annotation.PathVariable";
    protected static final String PARAM_ANNOTATION = "org.springframework.web.bind.annotation.RequestParam";
    protected static final String REQUESTBODY_ANNOTATION = "org.springframework.web.bind.annotation.RequestBody";

    @Override
    protected boolean shouldIgnoreClass(ClassDoc classDoc) {
        for (AnnotationDesc classAnnotation : classDoc.annotations()) {
            if (!CONTROLLER_ANNOTATION.contains(AnnotationUtils.getAnnotationName(classAnnotation))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean shouldIgnoreMethod(MethodDoc methodDoc) {
        for (AnnotationDesc classAnnotation : methodDoc.annotations()) {
            if (!MAPPING_ANNOTATION.equals(AnnotationUtils.getAnnotationName(classAnnotation))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EndpointMapping getEndpointMapping(ProgramElementDoc doc) {
        for (AnnotationDesc annotation : doc.annotations()) {
            if (!MAPPING_ANNOTATION.equals(AnnotationUtils.getAnnotationName(annotation))) continue;
            LinkedHashSet<String> httpMethods = new LinkedHashSet<String>();
            for (String value : AnnotationUtils.getElementValue(annotation, "method")) {
                httpMethods.add(value.substring(value.lastIndexOf(".") + 1));
            }
            return new EndpointMapping(new LinkedHashSet<String>(AnnotationUtils.getElementValue(annotation, "value")), httpMethods, new LinkedHashSet<String>(AnnotationUtils.getElementValue(annotation, "consumes")), new LinkedHashSet<String>(AnnotationUtils.getElementValue(annotation, "produces")));
        }
        return new EndpointMapping(Collections.<String>emptySet(), Collections.<String>emptySet(), Collections.<String>emptySet(), Collections.<String>emptySet());
    }

    @Override
    protected Collection<PathVar> generatePathVars(MethodDoc methodDoc) {
        ArrayList<PathVar> retVal = new ArrayList<PathVar>();
        Tag[] tags = methodDoc.tags("pathVar");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            for (AnnotationDesc annotation : parameter.annotations()) {
                String text;
                if (!AnnotationUtils.getAnnotationName(annotation).equals(PATHVAR_ANNOTATION)) continue;
                String name = parameter.name();
                List<String> values = AnnotationUtils.getElementValue(annotation, "value");
                if (!values.isEmpty()) {
                    name = (String)values.iterator().next();
                }
                if ((text = TagUtils.findParamText(tags, name)) == null) {
                    text = TagUtils.findParamText(paramTags, parameter.name());
                }
                if (text == null) {
                    text = "";
                }
                retVal.add(new PathVar(name, text, parameter.type().qualifiedTypeName()));
            }
        }
        return retVal;
    }

    @Override
    protected Collection<QueryParam> generateQueryParams(MethodDoc methodDoc) {
        ArrayList<QueryParam> retVal = new ArrayList<QueryParam>();
        Tag[] tags = methodDoc.tags("queryParam");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            for (AnnotationDesc annotation : parameter.annotations()) {
                String text;
                List<String> defaultVals;
                if (!AnnotationUtils.getAnnotationName(annotation).equals(PARAM_ANNOTATION)) continue;
                String name = parameter.name();
                List<String> values = AnnotationUtils.getElementValue(annotation, "value");
                if (!values.isEmpty()) {
                    name = values.get(0);
                }
                List<String> requiredVals = AnnotationUtils.getElementValue(annotation, "required");
                boolean required = Boolean.TRUE;
                if (!requiredVals.isEmpty()) {
                    required = Boolean.parseBoolean(requiredVals.get(0));
                }
                if (!(defaultVals = AnnotationUtils.getElementValue(annotation, "defaultValue")).isEmpty()) {
                    required = Boolean.FALSE;
                }
                if ((text = TagUtils.findParamText(tags, name)) == null) {
                    text = TagUtils.findParamText(paramTags, parameter.name());
                }
                if (text == null) {
                    text = "";
                }
                retVal.add(new QueryParam(name, required, text, parameter.type().qualifiedTypeName()));
            }
        }
        return retVal;
    }

    @Override
    protected RequestBody generateRequestBody(MethodDoc methodDoc) {
        Tag[] tags = methodDoc.tags("requestBody");
        ParamTag[] paramTags = methodDoc.paramTags();
        for (Parameter parameter : methodDoc.parameters()) {
            for (AnnotationDesc annotation : parameter.annotations()) {
                String text;
                if (!AnnotationUtils.getAnnotationName(annotation).equals(REQUESTBODY_ANNOTATION)) continue;
                String string = text = CommonUtils.isEmpty(tags) ? null : tags[0].text();
                if (text == null) {
                    text = TagUtils.findParamText(paramTags, parameter.name());
                }
                if (text == null) {
                    text = "";
                }
                return new RequestBody(parameter.name(), text, parameter.type().qualifiedTypeName());
            }
        }
        return null;
    }

    @Override
    protected Collection<String> resolveHttpMethods(EndpointMapping classMapping, EndpointMapping methodMapping) {
        return CommonUtils.firstNonEmpty(super.resolveHttpMethods(classMapping, methodMapping), Arrays.asList("GET"));
    }
}

