/*******************************************************************************
 *  Copyright 2017 Anteros Tecnologia
 *   
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *  
 *  	http://www.apache.org/licenses/LICENSE-2.0
 *   
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *******************************************************************************/
package br.com.anteros.restdoc.maven.plugin.doclet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;

/**
 * Classe utilizada para representar os objetos vindos pelo corpo da requisição
 * 
 * @author Edson Martins
 * @author Eduardo Albertini
 *
 */
public class RequestBody {

	private String name;
	private String description;
	private String type;

	public RequestBody() {
	}

	public RequestBody(String name, String description, String type) {
		this.name = name;
		this.description = description;
		this.type = type;
	}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public String getType() {
		return type;
	}

	@JsonIgnore
	public String getSimpleType() {
		if (type == null)
			return type;
		if (type.lastIndexOf(".") == -1)
			return type;

		return type.substring(type.lastIndexOf(".") + 1);
	}

	@Override
	public String toString() {
		return "RequestBody{" + "name='" + name + '\'' + ", description='" + description + '\'' + '}';
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setType(String type) {
		this.type = type;
	}
}
