/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.transaction.impl;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.persistence.session.context.SQLPersistenceContext;
import br.com.anteros.persistence.transaction.Transaction;
import br.com.anteros.persistence.transaction.TransactionFactory;
import br.com.anteros.persistence.transaction.impl.JTATransaction;
import br.com.anteros.persistence.transaction.impl.TransactionException;
import java.sql.Connection;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class JTATransactionFactory
implements TransactionFactory {
    private static Logger log = LoggerProvider.getInstance().getLogger(JTATransactionFactory.class.getName());
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private InitialContext initialContext;

    public Transaction createTransaction(Connection connection, SQLPersistenceContext context) throws Exception {
        this.initialContext = new InitialContext();
        return new JTATransaction(connection, context, this.getUserTransaction());
    }

    protected UserTransaction getUserTransaction() {
        log.info((Object)"Attempting to locate UserTransaction via JNDI [java:comp/UserTransaction]");
        try {
            UserTransaction ut = (UserTransaction)this.getInitialContext().lookup(DEFAULT_USER_TRANSACTION_NAME);
            if (ut == null) {
                throw new TransactionException("Naming service lookup for UserTransaction returned null [java:comp/UserTransaction]");
            }
            log.info((Object)"Obtained UserTransaction");
            return ut;
        }
        catch (NamingException ne) {
            throw new TransactionException("Could not find UserTransaction in JNDI [java:comp/UserTransaction]", (Exception)ne);
        }
    }

    protected InitialContext getInitialContext() {
        return this.initialContext;
    }
}

