/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session.impl;

import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.persistence.handler.ArrayListHandler;
import br.com.anteros.persistence.handler.ResultSetHandler;
import br.com.anteros.persistence.metadata.annotation.type.CallableType;
import br.com.anteros.persistence.metadata.descriptor.DescriptionNamedQuery;
import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.session.ProcedureResult;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.impl.SQLQueryImpl;
import br.com.anteros.persistence.session.query.SQLQueryException;
import br.com.anteros.persistence.session.query.TypedSQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StoredProcedureSQLQueryImpl<T>
extends SQLQueryImpl<T> {
    protected CallableType callableType;
    protected String procedureName;
    protected ProcedureResult lastResult = null;

    public StoredProcedureSQLQueryImpl(SQLSession session, CallableType callableType) {
        super(session);
        this.callableType = callableType;
    }

    public StoredProcedureSQLQueryImpl(SQLSession session, Class<?> resultClass, CallableType callableType) {
        super(session, resultClass);
        this.callableType = callableType;
    }

    public Object getOutputParameterValue(int position) {
        if (this.lastResult == null) {
            throw new SQLQueryException("\u00c9 necess\u00e1rio executar o procedimento/fun\u00e7\u00e3o antes de obter o valor do par\u00e2metro de sa\u00edda. Procedimento/fun\u00e7\u00e3o " + this.procedureName + " tipo: " + this.callableType);
        }
        int i = 0;
        for (Object value : this.lastResult.getOutputParameters().values()) {
            if (i == position) {
                return value;
            }
            ++i;
        }
        throw new SQLQueryException("N\u00e3o encontrado par\u00e2metro para a posi\u00e7\u00e3o " + position + ". Procedimento/fun\u00e7\u00e3o " + this.procedureName + " tipo: " + this.callableType);
    }

    public Object getOutputParameterValue(String parameterName) {
        if (this.lastResult == null) {
            throw new SQLQueryException("\u00c9 necess\u00e1rio executar o procedimento/fun\u00e7\u00e3o antes de obter o valor do par\u00e2metro de sa\u00edda. Procedimento/fun\u00e7\u00e3o " + this.procedureName + " tipo: " + this.callableType);
        }
        return this.lastResult.getOutPutParameter(parameterName);
    }

    public ProcedureResult execute() throws Exception {
        if (this.parameters.size() > 0 && this.namedParameters.size() > 0 || this.parameters.size() > 0 && this.namedParameters.size() == 0) {
            throw new SQLQueryException("Use apenas par\u00e2metros nomeados para execu\u00e7\u00e3o de procedimento ou fun\u00e7\u00e3o.");
        }
        if (StringUtils.isEmpty((String)this.procedureName)) {
            throw new SQLQueryException("Informe o nome do procedimento ou fun\u00e7\u00e3o para executar.");
        }
        if (this.callableType == null) {
            throw new SQLQueryException("Informe se o tipo de objeto para execu\u00e7\u00e3o \u00e9 um PROCEDIMENTO ou uma FUN\u00c7\u00c3O.");
        }
        this.session.flush();
        if (this.namedParameters.size() > 0) {
            Collection values = this.namedParameters.values();
            this.lastResult = this.session.getRunner().executeProcedure(this.session, this.session.getDialect(), this.callableType, this.procedureName, values.toArray(new NamedParameter[0]), this.showSql, this.timeOut, this.session.clientId());
        } else {
            this.lastResult = this.session.getRunner().executeProcedure(this.session, this.session.getDialect(), this.callableType, this.procedureName, new NamedParameter[0], this.showSql, this.timeOut, this.session.clientId());
        }
        return this.lastResult;
    }

    public TypedSQLQuery<T> namedStoredProcedureQuery(String name) {
        this.setNamedQuery(name);
        return this;
    }

    public T getSingleResult() throws Exception {
        if (this.customHandler == null) {
            ProcedureResult procedureResult = this.execute();
            if (this.callableType == CallableType.FUNCTION) {
                procedureResult.close();
                return (T)procedureResult.getFunctionResult();
            }
            if (NamedParameter.countOutputParameters(this.namedParameters.values()) == 1) {
                Object result = procedureResult.getOutputParameters().values().iterator().next();
                procedureResult.close();
                return (T)result;
            }
            return (T)procedureResult;
        }
        List<T> result = this.getResultList();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List<T> getResultList() throws Exception {
        if (this.getNamedQuery() != null) {
            throw new UnsupportedOperationException("Procedimento nomeado ainda n\u00e3o implementado.");
        }
        if (this.parameters.size() > 0 && this.namedParameters.size() > 0 || this.parameters.size() > 0 && this.namedParameters.size() == 0) {
            throw new SQLQueryException("Use apenas par\u00e2metros nomeados para execu\u00e7\u00e3o de procedimento ou fun\u00e7\u00e3o.");
        }
        if (this.getNamedQuery() != null) {
            DescriptionNamedQuery namedQuery = this.findNamedQuery();
            if (namedQuery == null) {
                throw new SQLQueryException("Procedimento nomeado " + this.getNamedQuery() + " n\u00e3o encontrado.");
            }
            this.sql(namedQuery.getQuery());
        }
        List result = Collections.emptyList();
        T resultObject = this.getResultObjectByCustomHandler((ResultSetHandler)(this.customHandler != null ? this.customHandler : new ArrayListHandler()));
        if (resultObject != null) {
            if (resultObject instanceof Collection) {
                result = new ArrayList((Collection)resultObject);
            } else {
                result = new ArrayList();
                result.add(resultObject);
            }
        }
        return result;
    }

    protected T getResultObjectByCustomHandler(ResultSetHandler customHandler) throws Exception {
        if (this.getNamedQuery() != null) {
            throw new UnsupportedOperationException("Procedimento/fun\u00e7\u00e3o nomeado ainda n\u00e3o implementado.");
        }
        if (this.parameters.size() > 0 && this.namedParameters.size() > 0) {
            throw new SQLQueryException("Use apenas par\u00e2metros nomeados para execu\u00e7\u00e3o de procedimento ou fun\u00e7\u00e3o.");
        }
        if (customHandler == null) {
            throw new SQLQueryException("Informe o ResultSetHandler para executar a consulta.");
        }
        if (StringUtils.isEmpty((String)this.procedureName)) {
            throw new SQLQueryException("Informe o nome do procedimento ou fun\u00e7\u00e3o para executar.");
        }
        if (this.callableType == null) {
            throw new SQLQueryException("Informe se o tipo de objeto para execu\u00e7\u00e3o \u00e9 um PROCEDIMENTO ou uma FUN\u00c7\u00c3O.");
        }
        this.session.flush();
        Object result = null;
        if (this.namedParameters.size() > 0) {
            Collection values = this.namedParameters.values();
            result = this.session.getRunner().queryProcedure(this.session, this.session.getDialect(), this.callableType, this.procedureName, customHandler, values.toArray(new NamedParameter[0]), this.showSql, this.timeOut, this.session.clientId());
        } else {
            result = this.session.getRunner().queryProcedure(this.session, this.session.getDialect(), this.callableType, this.procedureName, customHandler, new NamedParameter[0], this.showSql, this.timeOut, this.session.clientId());
        }
        return (T)result;
    }

    public TypedSQLQuery<T> callableType(CallableType type) {
        this.callableType = type;
        return this;
    }

    public TypedSQLQuery<T> procedureOrFunctionName(String procedureName) {
        this.procedureName = procedureName;
        return this;
    }

    public TypedSQLQuery<T> setParameters(Object[] parameters) throws Exception {
        if (parameters != null && parameters.length > 0 && parameters[0] instanceof NamedParameter) {
            ArrayList<NamedParameter> params = new ArrayList<NamedParameter>();
            for (Object p : parameters) {
                params.add((NamedParameter)p);
            }
            this.setParameters(params.toArray(new NamedParameter[0]));
            return this;
        }
        throw new SQLQueryException("Formato para setParameters inv\u00e1lido. Use NamedParameter[] ou Map para execu\u00e7\u00e3o de Procedimento/fun\u00e7\u00e3o ");
    }

    public TypedSQLQuery<T> setParameters(Map parameters) throws Exception {
        int paramCount = 0;
        this.namedParameters.clear();
        for (Object namedParameter : parameters.keySet()) {
            this.namedParameters.put(++paramCount, new NamedParameter(namedParameter + ""));
        }
        return super.setParameters(parameters);
    }

    public TypedSQLQuery<T> setParameters(NamedParameter[] parameters) throws Exception {
        int paramCount = 0;
        this.namedParameters.clear();
        for (NamedParameter namedParameter : parameters) {
            this.namedParameters.put(++paramCount, namedParameter);
        }
        return super.setParameters(parameters);
    }
}

