/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session.configuration;

import br.com.anteros.core.resource.messages.AnterosBundle;
import br.com.anteros.core.resource.messages.AnterosResourceBundle;
import br.com.anteros.core.utils.IOUtils;
import br.com.anteros.core.utils.ObjectUtils;
import br.com.anteros.persistence.metadata.accessor.PropertyAccessorFactory;
import br.com.anteros.persistence.metadata.accessor.impl.PropertyAcessorFactoryImpl;
import br.com.anteros.persistence.metadata.configuration.PersistenceModelConfiguration;
import br.com.anteros.persistence.resource.messages.AnterosPersistenceMessages;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.configuration.AbstractPersistenceConfiguration;
import br.com.anteros.persistence.session.configuration.AnterosPersistenceConfigurationBase;
import br.com.anteros.persistence.session.configuration.DataSourceConfiguration;
import br.com.anteros.persistence.session.configuration.DataSourcesConfiguration;
import br.com.anteros.persistence.session.configuration.PackageScanEntity;
import br.com.anteros.persistence.session.configuration.PlaceholderConfiguration;
import br.com.anteros.persistence.session.configuration.PropertyConfiguration;
import br.com.anteros.persistence.session.configuration.SessionFactoryConfiguration;
import br.com.anteros.persistence.session.configuration.exception.AnterosConfigurationException;
import br.com.anteros.persistence.session.impl.SQLSessionFactoryImpl;
import br.com.anteros.xml.helper.XMLReader;
import java.io.InputStream;
import javax.sql.DataSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnterosPersistenceConfiguration
extends AnterosPersistenceConfigurationBase {
    private static AnterosBundle MESSAGES = AnterosResourceBundle.getBundle((String)"ANTEROS_PERSISTENCE", AnterosPersistenceMessages.class);

    public AnterosPersistenceConfiguration() {
    }

    public AnterosPersistenceConfiguration(DataSource dataSource) {
        super(dataSource);
    }

    public AnterosPersistenceConfiguration(PersistenceModelConfiguration modelConfiguration) {
        super(modelConfiguration);
    }

    public AnterosPersistenceConfiguration(DataSource dataSource, PersistenceModelConfiguration modelConfiguration) {
        super(dataSource, modelConfiguration);
    }

    public PropertyAccessorFactory getPropertyAccessorFactory() {
        return new PropertyAcessorFactoryImpl();
    }

    public SQLSessionFactory buildSessionFactory() throws Exception {
        this.prepareClassesToLoad();
        this.buildDataSource();
        if (this.dataSource == null) {
            throw new AnterosConfigurationException(MESSAGES.getMessage(((Object)((Object)this)).getClass().getSimpleName() + ".datasourceNotConfigured"));
        }
        SQLSessionFactoryImpl sessionFactory = new SQLSessionFactoryImpl(this.entityCacheManager, this.dataSource, this.getSessionFactoryConfiguration());
        this.loadEntities(sessionFactory.getDialect());
        sessionFactory.generateDDL();
        return sessionFactory;
    }

    protected AbstractPersistenceConfiguration parseXmlConfiguration(InputStream xmlConfiguration) throws Exception {
        String xml = IOUtils.toString((InputStream)xmlConfiguration);
        SessionFactoryConfiguration sessionFactoryConfiguration = new SessionFactoryConfiguration();
        sessionFactoryConfiguration.setPlaceholder(new PlaceholderConfiguration(XMLReader.readAttributeFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "placeholder"), (String)"location")));
        sessionFactoryConfiguration.setPackageToScanEntity(new PackageScanEntity(XMLReader.readAttributeFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "package-scan-entity"), (String)"package-name")));
        sessionFactoryConfiguration.setIncludeSecurityModel(((Boolean)ObjectUtils.convert((Object)XMLReader.readElementFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "include-security-model")), Boolean.class)).booleanValue());
        DataSourcesConfiguration dataSourcesConfiguration = new DataSourcesConfiguration();
        sessionFactoryConfiguration.setDataSources(dataSourcesConfiguration);
        NodeList dataSources = XMLReader.readNodesFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "dataSources/dataSource"));
        int length = dataSources.getLength();
        for (int i = 0; i < length; ++i) {
            Node dataSource = dataSources.item(i);
            DataSourceConfiguration dataSourceConfiguration = new DataSourceConfiguration(XMLReader.readAttributeFromNode((Node)dataSource, (String)"dataSource", (String)"id"), XMLReader.readAttributeFromNode((Node)dataSource, (String)"dataSource", (String)"className"));
            NodeList properties = XMLReader.readNodesFromNode((Node)dataSource, (String)"dataSource/property");
            int zLength = properties.getLength();
            for (int z = 0; z < zLength; ++z) {
                Node property = properties.item(z);
                PropertyConfiguration propertyConfiguration = new PropertyConfiguration(XMLReader.readAttributeFromNode((Node)property, (String)"property", (String)"name"), XMLReader.readAttributeFromNode((Node)property, (String)"property", (String)"value"));
                dataSourceConfiguration.getProperties().add(propertyConfiguration);
            }
            dataSourcesConfiguration.getDataSources().add(dataSourceConfiguration);
        }
        NodeList sessionProperties = XMLReader.readNodesFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "properties/property"));
        int zLength = sessionProperties.getLength();
        for (int z = 0; z < zLength; ++z) {
            Node property = sessionProperties.item(z);
            sessionFactoryConfiguration.addProperty(XMLReader.readAttributeFromNode((Node)property, (String)"property", (String)"name"), XMLReader.readAttributeFromNode((Node)property, (String)"property", (String)"value"));
        }
        NodeList annotatedClasses = XMLReader.readNodesFromXML((String)xml, (String)(SESSION_FACTORY_PATH + "/" + "annotatedClasses"));
        int zLength2 = annotatedClasses.getLength();
        for (int z = 0; z < zLength2; ++z) {
            Node property = annotatedClasses.item(z);
            sessionFactoryConfiguration.addAnnotatedClass(XMLReader.readElementFromNode((Node)property, (String)"className"));
        }
        this.setSessionFactory(sessionFactoryConfiguration);
        return this;
    }

    public AnterosPersistenceConfiguration setPackageToScanEntity(PackageScanEntity packageToScanEntity) {
        this.getSessionFactoryConfiguration().setPackageToScanEntity(packageToScanEntity);
        return this;
    }
}

