/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.transaction.impl;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.persistence.session.context.SQLPersistenceContext;
import br.com.anteros.persistence.transaction.AbstractTransaction;
import br.com.anteros.persistence.transaction.impl.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;

public class JDBCTransaction
extends AbstractTransaction {
    private static Logger log = LoggerProvider.getInstance().getLogger(JDBCTransaction.class.getName());
    private boolean toggleAutoCommit;

    public JDBCTransaction(Connection connection, SQLPersistenceContext context) {
        super(connection, context);
    }

    protected void doBegin() {
        try {
            this.toggleAutoCommit = this.getConnection().getAutoCommit();
            log.debug((Object)("status atual do autocommit: " + this.toggleAutoCommit));
            if (this.getConnection().getAutoCommit()) {
                log.debug((Object)"desabilitando autocommit");
                this.getConnection().setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            log.error((Object)"JDBC begin falhou", (Throwable)e);
            throw new TransactionException("JDBC begin failed: ", (Exception)e);
        }
    }

    protected void doCommit() {
        try {
            this.commitAndResetAutoCommit();
            log.debug((Object)"committed JDBC Connection");
        }
        catch (Exception e) {
            throw new TransactionException("unable to commit against JDBC connection", e);
        }
    }

    private void commitAndResetAutoCommit() throws SQLException {
        try {
            this.getConnection().commit();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    private void rollbackAndResetAutoCommit() throws SQLException {
        try {
            this.getConnection().rollback();
        }
        finally {
            this.toggleAutoCommit();
        }
    }

    private void toggleAutoCommit() {
        try {
            if (this.toggleAutoCommit) {
                log.debug((Object)"re-enabling autocommit");
                this.getConnection().setAutoCommit(true);
            }
        }
        catch (Exception sqle) {
            log.error((Object)"Could not toggle autocommit", (Throwable)sqle);
        }
    }

    protected void doRollback() {
        try {
            this.rollbackAndResetAutoCommit();
            log.debug((Object)"rolled back JDBC Connection");
        }
        catch (SQLException e) {
            throw new TransactionException("JDBC rollback failed", (Exception)e);
        }
    }
}

