/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session.context;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.persistence.session.AbstractSQLSessionFactory;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.context.CurrentSQLSessionContext;
import br.com.anteros.persistence.session.exception.SQLSessionException;
import br.com.anteros.persistence.transaction.TransactionManagerLookup;
import java.util.Hashtable;
import java.util.Map;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class JTASQLSessionContext
implements CurrentSQLSessionContext {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerProvider.getInstance().getLogger(JTASQLSessionContext.class.getName());
    protected final SQLSessionFactory factory;
    private transient Map<Transaction, SQLSession> currentSessionMap = new Hashtable<Transaction, SQLSession>();

    public JTASQLSessionContext(SQLSessionFactory factory) {
        this.factory = factory;
    }

    public SQLSession currentSession() throws Exception {
        Transaction txnIdentifier;
        SQLSession currentSession;
        Transaction txn;
        TransactionManager transactionManager = null;
        if (this.factory instanceof AbstractSQLSessionFactory) {
            transactionManager = ((AbstractSQLSessionFactory)this.factory).getTransactionManager();
        }
        if (transactionManager == null) {
            throw new SQLSessionException("No TransactionManagerLookup specified");
        }
        try {
            txn = transactionManager.getTransaction();
            if (txn == null) {
                throw new SQLSessionException("Unable to locate current JTA transaction");
            }
            if (!this.isInProgress(txn.getStatus())) {
                throw new SQLSessionException("Current transaction is not in progress");
            }
        }
        catch (SQLSessionException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SQLSessionException("Problem locating/validating JTA transaction", t);
        }
        TransactionManagerLookup lookup = null;
        if (this.factory instanceof AbstractSQLSessionFactory) {
            lookup = ((AbstractSQLSessionFactory)this.factory).getTransactionManagerLookup();
        }
        if ((currentSession = this.currentSessionMap.get(txnIdentifier = lookup == null ? txn : lookup.getTransactionIdentifier(txn))) == null || currentSession.isClosed() || !currentSession.getConnection().isValid(2000)) {
            currentSession = this.factory.openSession();
            try {
                txn.registerSynchronization((Synchronization)new CleaningSession(txnIdentifier, this));
            }
            catch (Throwable t) {
                try {
                    currentSession.close();
                }
                catch (Throwable ignore) {
                    log.debug((Object)"Unable to release generated current-session on failed synch registration", ignore);
                }
                throw new SQLSessionException("Unable to register cleanup Synchronization with TransactionManager");
            }
            this.currentSessionMap.put(txnIdentifier, currentSession);
        }
        return currentSession;
    }

    private boolean isInProgress(int status) {
        return status == 0 || status == 1;
    }

    protected static class CleaningSession
    implements Synchronization {
        private Object transactionIdentifier;
        private JTASQLSessionContext context;

        public CleaningSession(Object transactionIdentifier, JTASQLSessionContext context) {
            this.transactionIdentifier = transactionIdentifier;
            this.context = context;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
            this.context.currentSessionMap.remove(this.transactionIdentifier);
        }
    }
}

