/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.transaction.impl;

import br.com.anteros.persistence.transaction.AnterosSynchronization;
import br.com.anteros.persistence.transaction.impl.NullSynchronizationException;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(SynchronizationRegistry.class);
    private LinkedHashSet<AnterosSynchronization> synchronizations;

    public void registerSynchronization(AnterosSynchronization synchronization) {
        boolean added;
        if (synchronization == null) {
            throw new NullSynchronizationException();
        }
        if (this.synchronizations == null) {
            this.synchronizations = new LinkedHashSet();
        }
        if (!(added = this.synchronizations.add(synchronization))) {
            log.info("Synchronization [{}] was already registered", (Object)synchronization);
        }
    }

    public void notifySynchronizationsBeforeTransactionCompletion() {
        if (this.synchronizations != null) {
            for (AnterosSynchronization synchronization : this.synchronizations) {
                try {
                    synchronization.beforeCompletion();
                }
                catch (Throwable t) {
                    log.error("exception calling user Synchronization [{}]", (Object)synchronization, (Object)t);
                }
            }
        }
    }

    public void notifySynchronizationsAfterTransactionCompletion(int status) {
        if (this.synchronizations != null) {
            for (AnterosSynchronization synchronization : this.synchronizations) {
                try {
                    synchronization.afterCompletion(status);
                }
                catch (Throwable t) {
                    log.error("exception calling user Synchronization [{}]", (Object)synchronization, (Object)t);
                }
            }
        }
    }
}

