/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.transaction.impl;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.persistence.session.context.SQLPersistenceContext;
import br.com.anteros.persistence.transaction.AbstractTransaction;
import br.com.anteros.persistence.transaction.TransactionSatus;
import br.com.anteros.persistence.transaction.impl.TransactionException;
import java.sql.Connection;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class JTATransaction
extends AbstractTransaction {
    private static Logger log = LoggerProvider.getInstance().getLogger(JTATransaction.class.getName());
    private UserTransaction userTransaction;
    private boolean newTransaction;

    public JTATransaction(Connection connection, SQLPersistenceContext context, UserTransaction userTransaction) {
        this(connection, context);
    }

    public JTATransaction(Connection connection, SQLPersistenceContext context) {
        super(connection, context);
    }

    protected void doBegin() throws Exception {
        boolean bl = this.newTransaction = this.userTransaction.getStatus() == 6;
        if (this.newTransaction) {
            this.userTransaction.begin();
            log.debug((Object)"Began a new JTA transaction");
        }
    }

    protected void doCommit() throws Exception {
        this.userTransaction.commit();
        log.debug((Object)"Committed JTA UserTransaction");
    }

    protected void doRollback() throws Exception {
        this.userTransaction.rollback();
        log.debug((Object)"Rolled back JTA UserTransaction");
    }

    protected boolean doExtendedActiveCheck() {
        int status;
        if (this.status != TransactionSatus.ACTIVE || this.status == TransactionSatus.FAILED_COMMIT || this.status == TransactionSatus.COMMITTED) {
            return false;
        }
        try {
            status = this.userTransaction.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 0;
    }
}

