/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session;

import br.com.anteros.cloud.integration.filesharing.CloudFileManager;
import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.EntityCacheManager;
import br.com.anteros.persistence.schema.SchemaManager;
import br.com.anteros.persistence.schema.type.TableCreationType;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.configuration.AnterosPersistenceProperties;
import br.com.anteros.persistence.session.configuration.SessionFactoryConfiguration;
import br.com.anteros.persistence.session.context.CurrentSQLSessionContext;
import br.com.anteros.persistence.session.context.JTASQLSessionContext;
import br.com.anteros.persistence.session.context.ManagedSQLSessionContext;
import br.com.anteros.persistence.session.context.ThreadLocalSQLSessionContext;
import br.com.anteros.persistence.session.exception.SQLSessionException;
import br.com.anteros.persistence.session.query.ShowSQLType;
import br.com.anteros.persistence.sql.dialect.DatabaseDialect;
import br.com.anteros.persistence.transaction.TransactionFactory;
import br.com.anteros.persistence.transaction.TransactionManagerLookup;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;

public abstract class AbstractSQLSessionFactory
implements SQLSessionFactory {
    private static Logger log = LoggerProvider.getInstance().getLogger(AbstractSQLSessionFactory.class.getName());
    protected DatabaseDialect dialect;
    protected EntityCacheManager entityCacheManager;
    protected DataSource dataSource;
    protected SessionFactoryConfiguration configuration;
    protected CurrentSQLSessionContext currentSessionContext;
    private TransactionManager transactionManager;
    private CurrentSQLSessionContext currentSessionContextTHL;
    private ShowSQLType[] showSql = new ShowSQLType[]{ShowSQLType.NONE};
    private boolean formatSql = false;
    private int queryTimeout = 0;
    private int lockTimeout = 0;
    private int batchSize = 0;
    private boolean useBeanValidation = true;
    protected CloudFileManager externalFileManager;
    protected boolean enableImageCompression;

    public AbstractSQLSessionFactory(EntityCacheManager entityCacheManager, DataSource dataSource, SessionFactoryConfiguration configuration, CloudFileManager externalFileManager, boolean enableImageCompression) throws Exception {
        this.entityCacheManager = entityCacheManager;
        this.dataSource = dataSource;
        this.configuration = configuration;
        this.externalFileManager = externalFileManager;
        this.enableImageCompression = enableImageCompression;
        if (configuration.getProperty("dialect") == null) {
            throw new SQLSessionException("Dialeto n\u00e3o definido. N\u00e3o foi poss\u00edvel instanciar SQLSessionFactory.");
        }
        String dialectProperty = configuration.getProperty("dialect");
        Class<?> dialectClass = Class.forName(dialectProperty);
        if (!ReflectionUtils.isExtendsClass(DatabaseDialect.class, dialectClass)) {
            throw new SQLSessionException("A classe " + dialectClass.getName() + " n\u00e3o implementa a classe " + DatabaseDialect.class.getName() + ".");
        }
        this.dialect = (DatabaseDialect)dialectClass.newInstance();
        this.dialect.setDefaultCatalog(configuration.getProperty("defaultCatalog"));
        this.dialect.setDefaultSchema(configuration.getProperty("defaultSchema"));
        if (configuration.getProperty("showsql") != null) {
            String propertyShowSql = configuration.getProperty("showsql");
            String[] splitShowSql = propertyShowSql.split("\\,");
            this.showSql = ShowSQLType.parse((String[])splitShowSql);
        }
        if (configuration.getProperty("formatsql") != null) {
            this.formatSql = new Boolean(configuration.getProperty("formatsql"));
        }
        if (configuration.getProperty("queryTimeout") != null) {
            this.queryTimeout = new Integer(configuration.getProperty("queryTimeout"));
        }
        if (configuration.getProperty("lock-timeout") != null) {
            this.lockTimeout = new Integer(configuration.getProperty("lock-timeout"));
        }
        if (configuration.getProperty("batchSize") != null) {
            this.batchSize = new Integer(configuration.getProperty("batchSize"));
        }
        if (configuration.getProperty("use-bean-validation") != null) {
            this.useBeanValidation = new Boolean(configuration.getProperty("use-bean-validation"));
        }
        this.currentSessionContext = this.buildCurrentSessionContext();
        this.currentSessionContextTHL = new ThreadLocalSQLSessionContext((SQLSessionFactory)this);
    }

    public SQLSession getCurrentSession() throws Exception {
        if (this.currentSessionContext == null) {
            throw new SQLSessionException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    protected CurrentSQLSessionContext buildCurrentSessionContext() throws Exception {
        String impl = this.configuration.getProperty("current-session-context");
        if (impl == null && this.transactionManager != null || "jta".equals(impl)) {
            return new JTASQLSessionContext(this);
        }
        if ("thread".equals(impl)) {
            return new ThreadLocalSQLSessionContext((SQLSessionFactory)this);
        }
        if ("managed".equals(impl)) {
            return new ManagedSQLSessionContext(this);
        }
        return new ThreadLocalSQLSessionContext((SQLSessionFactory)this);
    }

    protected abstract TransactionFactory getTransactionFactory();

    public void generateDDL() throws Exception {
        TableCreationType databaseDDLType = TableCreationType.NONE;
        TableCreationType scriptDDLType = TableCreationType.NONE;
        String databaseDDLGeneration = this.configuration.getPropertyDef("database-ddl-generation", "none");
        databaseDDLGeneration = databaseDDLGeneration != null ? databaseDDLGeneration.toLowerCase() : "none";
        String scriptDDLGeneration = this.configuration.getPropertyDef("script-ddl-generation", "none");
        scriptDDLGeneration = scriptDDLGeneration != null ? scriptDDLGeneration.toLowerCase() : "none";
        if ("none".equals(databaseDDLGeneration) && "none".equals(scriptDDLGeneration)) {
            return;
        }
        Boolean createReferentialIntegrity = Boolean.parseBoolean(this.configuration.getPropertyDef("create-referencial-integrity", "true"));
        if (databaseDDLGeneration.equals("create-tables")) {
            databaseDDLType = TableCreationType.CREATE;
        } else if (databaseDDLGeneration.equals("drop-and-create-tables")) {
            databaseDDLType = TableCreationType.DROP;
        } else if (databaseDDLGeneration.equals("create-or-extend-tables")) {
            databaseDDLType = TableCreationType.EXTEND;
        }
        if (scriptDDLGeneration.equals("create-tables")) {
            scriptDDLType = TableCreationType.CREATE;
        } else if (scriptDDLGeneration.equals("drop-and-create-tables")) {
            scriptDDLType = TableCreationType.DROP;
        } else if (scriptDDLGeneration.equals("create-or-extend-tables")) {
            scriptDDLType = TableCreationType.EXTEND;
        }
        this.generateDDL(databaseDDLType, scriptDDLType, createReferentialIntegrity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDDL(TableCreationType databaseDDLType, TableCreationType scriptDDLType, Boolean createReferentialIntegrity) throws Exception {
        if (databaseDDLType != TableCreationType.NONE || scriptDDLType != TableCreationType.NONE) {
            String ddlGenerationMode = this.configuration.getPropertyDef("ddl-output-mode", "database");
            if (ddlGenerationMode.equals("none")) {
                return;
            }
            SQLSession sessionForDDL = this.openSession();
            try {
                SchemaManager schemaManager = new SchemaManager(sessionForDDL, this.entityCacheManager, createReferentialIntegrity.booleanValue());
                schemaManager.setIgnoreDatabaseException(Boolean.valueOf(this.configuration.getPropertyDef("ddl-database-ignore-exception", "false")).booleanValue());
                this.beforeGenerateDDL(sessionForDDL);
                if (ddlGenerationMode.equals("sql-script") || ddlGenerationMode.equals("both")) {
                    String appLocation = this.configuration.getPropertyDef("application-location", AnterosPersistenceProperties.DEFAULT_APPLICATION_LOCATION);
                    String createDDLJdbc = this.configuration.getPropertyDef("create-tables-file-name", "createTables.sql");
                    String dropDDLJdbc = this.configuration.getPropertyDef("drop-tables-file-name", "dropTables.sql");
                    schemaManager.writeDDLsToFiles(scriptDDLType, appLocation, createDDLJdbc, dropDDLJdbc);
                }
                if (ddlGenerationMode.equals("database") || ddlGenerationMode.equals("both")) {
                    schemaManager.writeDDLToDatabase(databaseDDLType);
                }
                this.afterGenerateDDL(sessionForDDL);
            }
            finally {
                sessionForDDL.close();
            }
        }
    }

    public abstract void beforeGenerateDDL(SQLSession var1) throws Exception;

    public abstract void afterGenerateDDL(SQLSession var1) throws Exception;

    public DatabaseDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager enityCacheManager) {
        this.entityCacheManager = enityCacheManager;
    }

    public boolean isShowSql() {
        return this.showSql != null;
    }

    public ShowSQLType[] getShowSql() {
        return this.showSql;
    }

    public void setShowSql(ShowSQLType[] showSql) {
        this.showSql = showSql;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void onBeforeExecuteCommit(Connection connection) throws Exception {
        SQLSession session = this.getCurrentSession();
        if (session != null) {
            session.getPersistenceContext().onBeforeExecuteCommit(connection);
        }
    }

    public void onBeforeExecuteRollback(Connection connection) throws Exception {
        SQLSession session = this.getCurrentSession();
        if (session != null) {
            session.getPersistenceContext().onBeforeExecuteRollback(connection);
        }
    }

    public void onAfterExecuteCommit(Connection connection) throws Exception {
        SQLSession session = this.getCurrentSession();
        if (session != null) {
            session.getPersistenceContext().onAfterExecuteCommit(connection);
        }
    }

    public void onAfterExecuteRollback(Connection connection) throws Exception {
        SQLSession session = this.getCurrentSession();
        if (session != null) {
            session.getPersistenceContext().onAfterExecuteRollback(connection);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public SessionFactoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SessionFactoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    protected void setConfigurationClientInfo(Connection connection) throws IOException, SQLException {
        String clientInfo = this.getConfiguration().getProperty("connectionClientInfo");
        if (clientInfo != null && clientInfo.length() > 0) {
            this.getDialect().setConnectionClientInfo(connection, clientInfo);
        }
    }

    public abstract TransactionManagerLookup getTransactionManagerLookup() throws Exception;

    public TransactionManager getTransactionManager() throws Exception {
        log.info((Object)"obtaining TransactionManager");
        if (this.transactionManager == null) {
            this.transactionManager = this.getTransactionManagerLookup().getTransactionManager();
        }
        return this.transactionManager;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String toString() {
        return "AbstractSQLSessionFactory [dialect=" + this.dialect + ", entityCacheManager=" + this.entityCacheManager + ", dataSource=" + this.dataSource + ", configuration=" + this.configuration + ", currentSessionContext=" + this.currentSessionContext + ", transactionManager=" + this.transactionManager + ", showSql=" + Arrays.toString(this.showSql) + ", formatSql=" + this.formatSql + ", queryTimeout=" + this.queryTimeout + ", lockTimeout=" + this.lockTimeout + ", batchSize=" + this.batchSize + "]";
    }

    public boolean isUseBeanValidation() {
        return this.useBeanValidation;
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }
}

