/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session.impl;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.core.utils.StringUtils;
import br.com.anteros.persistence.handler.EntityHandler;
import br.com.anteros.persistence.metadata.EntityCache;
import br.com.anteros.persistence.metadata.EntityCacheManager;
import br.com.anteros.persistence.metadata.EntityListener;
import br.com.anteros.persistence.metadata.annotation.EventType;
import br.com.anteros.persistence.metadata.annotation.type.CallableType;
import br.com.anteros.persistence.metadata.descriptor.DescriptionColumn;
import br.com.anteros.persistence.metadata.descriptor.DescriptionField;
import br.com.anteros.persistence.metadata.identifier.Identifier;
import br.com.anteros.persistence.metadata.identifier.IdentifierGenerator;
import br.com.anteros.persistence.metadata.identifier.IdentifierGeneratorFactory;
import br.com.anteros.persistence.metadata.identifier.IdentifierPostInsert;
import br.com.anteros.persistence.parameter.NamedParameter;
import br.com.anteros.persistence.proxy.JavassistLazyLoadFactory;
import br.com.anteros.persistence.proxy.LazyLoadFactory;
import br.com.anteros.persistence.session.ExternalFileManager;
import br.com.anteros.persistence.session.FindParameters;
import br.com.anteros.persistence.session.SQLPersister;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.SQLSessionFactory;
import br.com.anteros.persistence.session.SQLSessionListener;
import br.com.anteros.persistence.session.cache.Cache;
import br.com.anteros.persistence.session.context.SQLPersistenceContext;
import br.com.anteros.persistence.session.exception.SQLSessionException;
import br.com.anteros.persistence.session.impl.SQLPersistenceContextImpl;
import br.com.anteros.persistence.session.impl.SQLPersisterImpl;
import br.com.anteros.persistence.session.impl.SQLQueryImpl;
import br.com.anteros.persistence.session.impl.StoredProcedureSQLQueryImpl;
import br.com.anteros.persistence.session.lock.LockManager;
import br.com.anteros.persistence.session.lock.LockManagerJDBC;
import br.com.anteros.persistence.session.lock.LockMode;
import br.com.anteros.persistence.session.lock.LockOptions;
import br.com.anteros.persistence.session.query.AbstractSQLRunner;
import br.com.anteros.persistence.session.query.ExpressionFieldMapper;
import br.com.anteros.persistence.session.query.SQLQuery;
import br.com.anteros.persistence.session.query.SQLQueryAnalyserAlias;
import br.com.anteros.persistence.session.query.ShowSQLType;
import br.com.anteros.persistence.session.query.TypedSQLQuery;
import br.com.anteros.persistence.sql.command.BatchCommandSQL;
import br.com.anteros.persistence.sql.command.CommandSQL;
import br.com.anteros.persistence.sql.dialect.DatabaseDialect;
import br.com.anteros.persistence.transaction.Transaction;
import br.com.anteros.persistence.transaction.TransactionFactory;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SQLSessionImpl
implements SQLSession {
    private static Logger LOG = LoggerProvider.getInstance().getLogger(SQLSession.class);
    public static int FIRST_RECORD = 0;
    private EntityCacheManager entityCacheManager;
    private Connection connection;
    private DatabaseDialect dialect;
    private AbstractSQLRunner queryRunner;
    private ShowSQLType[] showSql = new ShowSQLType[]{ShowSQLType.NONE};
    private boolean formatSql;
    private int queryTimeout = 0;
    private SQLPersistenceContext persistenceContext;
    private List<CommandSQL> commandQueue = new ArrayList<CommandSQL>();
    private SQLSessionFactory sessionFactory;
    private List<SQLSessionListener> listeners = new ArrayList<SQLSessionListener>();
    private Map<Object, Map<DescriptionColumn, IdentifierPostInsert>> cacheIdentifier = new LinkedHashMap<Object, Map<DescriptionColumn, IdentifierPostInsert>>();
    private SQLPersister persister;
    private LazyLoadFactory lazyLoadFactory = new JavassistLazyLoadFactory();
    private TransactionFactory transactionFactory;
    private Transaction transaction;
    private LockManager lockManager;
    private int batchSize = 0;
    private int currentBatchSize = 0;
    private Map<String, NextValControl> cacheSequenceNumbers = new HashMap<String, NextValControl>();
    private String clientId;
    private Object tenantId;
    private Object companyId;
    private boolean validationActive;
    private ExternalFileManager externalFileManager;

    public SQLSessionImpl(SQLSessionFactory sessionFactory, Connection connection, EntityCacheManager entityCacheManager, AbstractSQLRunner queryRunner, DatabaseDialect dialect, ShowSQLType[] showSql, boolean formatSql, int queryTimeout, int lockTimeout, TransactionFactory transactionFactory, int batchSize, boolean validationActive, ExternalFileManager fileManager) throws Exception {
        this.entityCacheManager = entityCacheManager;
        this.connection = connection;
        if (connection != null) {
            this.connection.setAutoCommit(false);
        }
        this.dialect = dialect;
        this.showSql = showSql;
        this.formatSql = formatSql;
        this.sessionFactory = sessionFactory;
        this.persistenceContext = new SQLPersistenceContextImpl((SQLSession)this, entityCacheManager);
        this.persister = new SQLPersisterImpl();
        this.queryRunner = queryRunner;
        this.queryTimeout = queryTimeout;
        this.transactionFactory = transactionFactory;
        this.lockManager = new LockManagerJDBC();
        this.batchSize = batchSize;
        this.validationActive = validationActive;
        this.externalFileManager = fileManager;
        String lockTimeoutSql = dialect.getSetLockTimeoutString(lockTimeout);
        if (!StringUtils.isEmpty((String)lockTimeoutSql)) {
            connection.prepareStatement(lockTimeoutSql).execute();
        }
    }

    public long update(String sql) throws Exception {
        this.errorIfClosed();
        return this.queryRunner.update((SQLSession)this, sql, this.listeners);
    }

    public long update(String sql, Object[] params) throws Exception {
        this.errorIfClosed();
        return this.queryRunner.update((SQLSession)this, sql, params, this.listeners);
    }

    public long update(String sql, NamedParameter[] params) throws Exception {
        this.errorIfClosed();
        return this.queryRunner.update((SQLSession)this, sql, params, this.listeners);
    }

    public Object save(Object object) throws Exception {
        this.errorIfClosed();
        return this.persister.save((SQLSession)this, object);
    }

    public void saveInBatchMode(Object object, int batchSize) throws Exception {
        this.errorIfClosed();
        this.currentBatchSize = batchSize;
        this.persister.save((SQLSession)this, object, batchSize);
    }

    public void saveInBatchMode(Object[] object, int batchSize) throws Exception {
        this.errorIfClosed();
        this.currentBatchSize = batchSize;
        for (Object obj : object) {
            this.persister.save((SQLSession)this, obj, batchSize);
        }
    }

    public void save(Object[] object) throws Exception {
        this.errorIfClosed();
        for (Object obj : object) {
            this.persister.save((SQLSession)this, obj);
        }
    }

    public void save(Collection<?> object) throws Exception {
        this.errorIfClosed();
        for (Object obj : object) {
            this.persister.save((SQLSession)this, obj);
        }
    }

    public void remove(Object object) throws Exception {
        this.errorIfClosed();
        this.persister.remove((SQLSession)this, object);
    }

    public void remove(Object[] object) throws Exception {
        this.errorIfClosed();
        this.persister.remove((SQLSession)this, object);
    }

    public DatabaseDialect getDialect() {
        return this.dialect;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public AbstractSQLRunner getRunner() throws Exception {
        return this.queryRunner;
    }

    public void setDialect(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public EntityCacheManager getEntityCacheManager() {
        return this.entityCacheManager;
    }

    public void setEntityCacheManager(EntityCacheManager entityCacheManager) {
        this.entityCacheManager = entityCacheManager;
    }

    public boolean isShowSql() {
        return this.showSql != null;
    }

    public ShowSQLType[] getShowSql() {
        return this.showSql;
    }

    public void setShowSql(ShowSQLType ... showSql) {
        this.showSql = showSql;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public SQLPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void flush() throws Exception {
        this.errorIfClosed();
        if (this.getCurrentBatchSize() > 0) {
            if (this.commandQueue.size() > 0) {
                new BatchCommandSQL((SQLSession)this, this.commandQueue.toArray(new CommandSQL[0]), this.getCurrentBatchSize(), this.getShowSql()).execute();
            }
        } else {
            for (CommandSQL command : this.commandQueue) {
                try {
                    command.execute();
                }
                catch (SQLException ex) {
                    throw this.getDialect().convertSQLException(ex, "Erro enviando comando sql.", command.getSql());
                }
            }
        }
        this.commandQueue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceFlush(Set<String> tableNames) throws Exception {
        this.errorIfClosed();
        if (tableNames != null) {
            List<CommandSQL> list = this.commandQueue;
            synchronized (list) {
                boolean foundCommand = false;
                for (CommandSQL command : this.commandQueue) {
                    if (!tableNames.contains(command.getTargetTableName().toUpperCase())) continue;
                    foundCommand = true;
                    break;
                }
                if (foundCommand) {
                    this.flush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        for (SQLSessionListener listener : this.listeners) {
            listener.onClose((SQLSession)this);
        }
        List<CommandSQL> list = this.commandQueue;
        synchronized (list) {
            this.commandQueue.clear();
        }
        this.currentBatchSize = 0;
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
        this.connection = null;
        LOG.debug((Object)("Fechou session " + this));
    }

    public void onBeforeExecuteCommit(Connection connection) throws Exception {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeforeExecuteRollback(Connection connection) throws Exception {
        if (this.getConnection() == connection) {
            List<CommandSQL> list = this.commandQueue;
            synchronized (list) {
                this.commandQueue.clear();
            }
        }
    }

    public void onAfterExecuteCommit(Connection connection) throws Exception {
        this.currentBatchSize = 0;
    }

    public void onAfterExecuteRollback(Connection connection) throws Exception {
        this.currentBatchSize = 0;
    }

    public AbstractSQLRunner getQueryRunner() {
        this.errorIfClosed();
        return this.queryRunner;
    }

    public void setQueryRunner(AbstractSQLRunner queryRunner) {
        this.errorIfClosed();
        this.queryRunner = queryRunner;
    }

    public <T> Identifier<T> getIdentifier(T owner) throws Exception {
        this.errorIfClosed();
        return Identifier.create((SQLSession)this, owner);
    }

    public <T> Identifier<T> createIdentifier(Class<T> clazz) throws Exception {
        this.errorIfClosed();
        return Identifier.create((SQLSession)this, clazz);
    }

    public void addListener(SQLSessionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SQLSessionListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public List<SQLSessionListener> getListeners() {
        return this.listeners;
    }

    public List<CommandSQL> getCommandQueue() {
        return this.commandQueue;
    }

    public Map<Object, Map<DescriptionColumn, IdentifierPostInsert>> getCacheIdentifier() {
        return this.cacheIdentifier;
    }

    public String clientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void save(Class<?> clazz, String[] columns, String[] values) throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o suportado.");
    }

    public void removeAll(Class<?> clazz) throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o suportado.");
    }

    public void removeTable(String tableName) throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o suportado.");
    }

    public void enablelockOptions() throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o implementado.");
    }

    public void disablelockOptions() throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o implementado.");
    }

    public void executeDDL(String ddl) throws Exception {
        this.errorIfClosed();
        this.getRunner().executeDDL((SQLSession)this, ddl, this.showSql, this.formatSql, "");
    }

    public EntityHandler createNewEntityHandler(Class<?> resultClass, Set<ExpressionFieldMapper> expressionsFieldMapper, Map<SQLQueryAnalyserAlias, Map<String, String[]>> columnAliases, Cache transactionCache, boolean allowDuplicateObjects, Object objectToRefresh, int firstResult, int maxResults, boolean readOnly, LockOptions lockOptions, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        EntityHandler handler = new EntityHandler(this.lazyLoadFactory, resultClass, this.getEntityCacheManager(), expressionsFieldMapper, columnAliases, (SQLSession)this, transactionCache, allowDuplicateObjects, firstResult, maxResults, readOnly, lockOptions, fieldsToForceLazy);
        handler.setObjectToRefresh(objectToRefresh);
        return handler;
    }

    public void lock(Object entity, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        this.lockManager.lock((SQLSession)this, entity, lockOptions);
    }

    public void lockAll(Collection<?> entities, LockOptions lockOptions) throws Exception {
        if (entities != null) {
            this.lockAll(entities.toArray(new Object[0]), lockOptions);
        }
    }

    public void lockAll(Object[] entities, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        for (Object entity : entities) {
            this.lock(entity, lockOptions);
        }
    }

    public boolean isProxyObject(Object object) throws Exception {
        return this.lazyLoadFactory.isProxyObject(object);
    }

    public boolean proxyIsInitialized(Object object) throws Exception {
        return this.lazyLoadFactory.proxyIsInitialized(object);
    }

    public void savePoint(String savepoint) throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o implementado.");
    }

    public void rollbackToSavePoint(String savepoint) throws Exception {
        this.errorIfClosed();
        throw new Exception("M\u00e9todo n\u00e3o implementado.");
    }

    public <T> T cloneEntityManaged(Object object) throws Exception {
        return null;
    }

    public void evict(Class object) {
        this.errorIfClosed();
        this.persistenceContext.evict(object);
    }

    public void evictAll() {
        this.errorIfClosed();
        this.persistenceContext.evictAll();
    }

    public boolean isClosed() throws Exception {
        return this.getConnection() == null || this.getConnection().isClosed();
    }

    public void setClientInfo(String clientInfo) throws SQLException {
        this.errorIfClosed();
        this.getDialect().setConnectionClientInfo(this.getConnection(), clientInfo);
    }

    public String getClientInfo() throws SQLException {
        this.errorIfClosed();
        return this.getDialect().getConnectionClientInfo(this.getConnection());
    }

    public Transaction getTransaction() throws Exception {
        if (this.transaction == null) {
            this.transaction = this.transactionFactory.createTransaction(this.getConnection(), this.getPersistenceContext());
        }
        return this.transaction;
    }

    public SQLSessionFactory getSQLSessionFactory() {
        return this.sessionFactory;
    }

    public void clear() throws Exception {
        this.internalClear();
    }

    private void internalClear() {
        this.persistenceContext.evictAll();
        this.persistenceContext.clearCache();
    }

    protected void errorIfClosed() {
        try {
            if (this.isClosed()) {
                throw new SQLSessionException("Sess\u00e3o est\u00e1 fechada!");
            }
        }
        catch (Exception ex) {
            throw new SQLSessionException("Sess\u00e3o est\u00e1 fechada!", (Throwable)ex);
        }
    }

    public <T> T find(FindParameters<T> params) throws Exception {
        if (params.getEntityClass() != null && params.getId() != null && params.getLockOptions() != null && params.getProperties() != null) {
            return this.find(params.getEntityClass(), params.getId(), params.getLockOptions(), params.getProperties(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getEntityClass() != null && params.getId() != null && params.getLockOptions() != null) {
            return this.find(params.getEntityClass(), params.getId(), params.getLockOptions(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getEntityClass() != null && params.getId() != null && params.getProperties() != null) {
            return this.find(params.getEntityClass(), params.getId(), params.getProperties(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getEntityClass() != null && params.getId() != null) {
            return this.find(params.getEntityClass(), params.getId(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getIdentifier() != null && params.getProperties() != null && params.getLockOptions() != null) {
            return this.find(params.getIdentifier(), params.getProperties(), params.getLockOptions(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getIdentifier() != null && params.getProperties() != null) {
            return this.find(params.getIdentifier(), params.getProperties(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getIdentifier() != null && params.getLockOptions() != null) {
            return this.find(params.getIdentifier(), params.getLockOptions(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        if (params.getIdentifier() != null) {
            return this.find(params.getIdentifier(), params.isReadOnly(), params.getFieldsToForceLazy());
        }
        return null;
    }

    public <T> T find(Class<T> entityClass, Object id, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entityClass);
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entityClass.getName());
        }
        if (id instanceof Identifier) {
            if (!((Identifier)id).getClazz().equals(entityClass)) {
                throw new SQLSessionException("Objeto ID \u00e9 do tipo Identifier por\u00e9m de uma classe diferente da classe " + entityClass.getName());
            }
            return this.find((Identifier)id, readOnly, fieldsToForceLazy);
        }
        Identifier identifier = Identifier.create((SQLSession)this, entityClass);
        identifier.setIdIfPossible(id);
        return this.find(identifier, readOnly, fieldsToForceLazy);
    }

    public <T> T find(Class<T> entityClass, Object id, Map<String, Object> properties, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entityClass);
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entityClass.getName());
        }
        T result = this.find(entityClass, id, readOnly, fieldsToForceLazy);
        entityCache.setObjectValues(result, properties);
        return result;
    }

    public <T> T find(Class<T> entityClass, Object id, LockOptions lockOptions, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entityClass);
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entityClass.getName());
        }
        if (id instanceof Identifier) {
            if (!((Identifier)id).getClazz().equals(entityClass)) {
                throw new SQLSessionException("Objeto ID \u00e9 do tipo Identifier por\u00e9m de uma classe diferente da classe " + entityClass.getName());
            }
            return this.find((Identifier)id, readOnly, fieldsToForceLazy);
        }
        Identifier identifier = Identifier.create((SQLSession)this, entityClass);
        identifier.setIdIfPossible(id);
        return this.find(identifier, lockOptions, readOnly, fieldsToForceLazy);
    }

    public <T> T find(Class<T> entityClass, Object id, LockOptions lockOptions, Map<String, Object> properties, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entityClass);
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entityClass.getName());
        }
        T result = this.find(entityClass, id, lockOptions, readOnly, fieldsToForceLazy);
        entityCache.setObjectValues(result, properties);
        return result;
    }

    public <T> T find(Identifier<T> id, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        SQLQuery query = this.createQuery("");
        query.setReadOnly(readOnly);
        query.setFieldsToForceLazy(fieldsToForceLazy);
        List result = query.identifier(id).getResultList();
        if (result == null || result.size() == 0) {
            return null;
        }
        return (T)result.get(0);
    }

    public <T> T find(Identifier<T> id, LockOptions lockOptions, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        SQLQuery query = this.createQuery("");
        query.setReadOnly(readOnly);
        query.setFieldsToForceLazy(fieldsToForceLazy);
        query.setLockOptions(lockOptions);
        List result = query.identifier(id).getResultList();
        if (result == null || result.size() == 0) {
            return null;
        }
        return (T)result.get(0);
    }

    public <T> T find(Identifier<T> id, Map<String, Object> properties, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        T result = this.find(id, readOnly, fieldsToForceLazy);
        id.getEntityCache().setObjectValues(result, properties);
        return result;
    }

    public <T> T find(Identifier<T> id, Map<String, Object> properties, LockOptions lockOptions, boolean readOnly, String fieldsToForceLazy) throws Exception {
        this.errorIfClosed();
        T result = this.find(id, lockOptions, readOnly, fieldsToForceLazy);
        id.getEntityCache().setObjectValues(result, properties);
        return result;
    }

    public void refresh(Object entity) throws Exception {
        this.errorIfClosed();
        if (entity == null) {
            return;
        }
        this.persistenceContext.detach(entity);
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entity.getClass());
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entity.getClass().getName());
        }
        Identifier identifier = Identifier.create((SQLSession)this, (Object)entity, (boolean)true);
        this.find(identifier, false, null);
    }

    public void refresh(Object entity, Map<String, Object> properties) throws Exception {
        this.errorIfClosed();
        if (entity == null) {
            return;
        }
        this.persistenceContext.detach(entity);
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entity.getClass());
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entity.getClass().getName());
        }
        Identifier identifier = Identifier.create((SQLSession)this, (Object)entity, (boolean)true);
        this.find(identifier, false, null);
        identifier.getEntityCache().setObjectValues(entity, properties);
    }

    public void refresh(Object entity, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        if (entity == null) {
            return;
        }
        this.persistenceContext.detach(entity);
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entity.getClass());
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entity.getClass().getName());
        }
        Identifier identifier = Identifier.create((SQLSession)this, (Object)entity, (boolean)true);
        this.find(identifier, lockOptions, false, null);
    }

    public void refresh(Object entity, LockOptions lockOptions, Map<String, Object> properties) throws Exception {
        this.errorIfClosed();
        if (entity == null) {
            return;
        }
        this.persistenceContext.detach(entity);
        EntityCache entityCache = this.entityCacheManager.getEntityCache(entity.getClass());
        if (entityCache == null) {
            throw new SQLSessionException("Classe n\u00e3o foi encontrada na lista de entidades gerenciadas. " + entity.getClass().getName());
        }
        Identifier identifier = Identifier.create((SQLSession)this, (Object)entity, (boolean)true);
        this.find(identifier, lockOptions, false, null);
        identifier.getEntityCache().setObjectValues(entity, properties);
    }

    public void detach(Object entity) {
        this.errorIfClosed();
        if (entity == null) {
            return;
        }
        this.persistenceContext.detach(entity);
    }

    public SQLQuery createQuery(String sql) throws Exception {
        return this.createQuery(sql, new LockOptions().setLockMode(LockMode.NONE));
    }

    public SQLQuery createQuery(String sql, Object parameters) throws Exception {
        return this.createQuery(sql, parameters, new LockOptions().setLockMode(LockMode.NONE));
    }

    public <T> TypedSQLQuery<T> createQuery(String sql, Class<T> resultClass) throws Exception {
        return this.createQuery(sql, resultClass, new LockOptions().setLockMode(LockMode.NONE));
    }

    public <T> TypedSQLQuery<T> createQuery(String sql, Class<T> resultClass, Object parameters) throws Exception {
        return this.createQuery(sql, resultClass, parameters, new LockOptions().setLockMode(LockMode.NONE));
    }

    public SQLQuery createQuery(String sql, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this);
        result.timeOut(this.queryTimeout);
        result.sql(sql);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        result.setLockOptions(lockOptions);
        return result;
    }

    public SQLQuery createQuery(String sql, Object parameters, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this);
        result.sql(sql);
        result.setParameters(parameters);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        result.setLockOptions(lockOptions);
        return result;
    }

    public <T> TypedSQLQuery<T> createQuery(String sql, Class<T> resultClass, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this, resultClass);
        result.sql(sql);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        result.setLockOptions(lockOptions);
        return result;
    }

    public <T> TypedSQLQuery<T> createQuery(String sql, Class<T> resultClass, Object parameters, LockOptions lockOptions) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this, resultClass);
        result.timeOut(this.queryTimeout);
        result.sql(sql);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        result.setParameters(parameters);
        result.setLockOptions(lockOptions);
        return result;
    }

    public SQLQuery createNamedQuery(String name) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this);
        result.namedQuery(name);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public SQLQuery createNamedQuery(String name, Object parameters) throws Exception {
        this.errorIfClosed();
        SQLQueryImpl result = new SQLQueryImpl((SQLSession)this);
        result.namedQuery(name);
        result.setParameters(parameters);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public <T> TypedSQLQuery<T> createNamedQuery(String name, Class<T> resultClass) throws Exception {
        this.errorIfClosed();
        return new SQLQueryImpl((SQLSession)this, resultClass).timeOut(this.queryTimeout).namedQuery(name).showSql(this.showSql).formatSql(this.formatSql);
    }

    public <T> TypedSQLQuery<T> createNamedQuery(String name, Class<T> resultClass, Object parameters) throws Exception {
        this.errorIfClosed();
        return new SQLQueryImpl((SQLSession)this, resultClass).namedQuery(name).setParameters(parameters).showSql(this.showSql).formatSql(this.formatSql);
    }

    public SQLQuery createStoredProcedureQuery(String procedureName, CallableType type) throws Exception {
        this.errorIfClosed();
        StoredProcedureSQLQueryImpl result = new StoredProcedureSQLQueryImpl(this, type);
        result.procedureOrFunctionName(procedureName);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public SQLQuery createStoredProcedureQuery(String procedureName, CallableType type, Object parameters) throws Exception {
        this.errorIfClosed();
        StoredProcedureSQLQueryImpl result = new StoredProcedureSQLQueryImpl(this, type);
        result.procedureOrFunctionName(procedureName);
        result.setParameters(parameters);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public <T> TypedSQLQuery<T> createStoredProcedureQuery(String procedureName, CallableType type, Class<T> resultClass) throws Exception {
        this.errorIfClosed();
        StoredProcedureSQLQueryImpl result = new StoredProcedureSQLQueryImpl(this, resultClass, type);
        result.procedureOrFunctionName(procedureName);
        result.timeOut(this.queryTimeout);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public <T> TypedSQLQuery<T> createStoredProcedureQuery(String procedureName, CallableType type, Class<T> resultClass, Object[] parameters) throws Exception {
        this.errorIfClosed();
        StoredProcedureSQLQueryImpl result = new StoredProcedureSQLQueryImpl(this, resultClass, type);
        result.procedureOrFunctionName(procedureName);
        result.timeOut(this.queryTimeout);
        result.setParameters(parameters);
        result.showSql(this.showSql);
        result.formatSql(this.formatSql);
        return result;
    }

    public SQLQuery createStoredProcedureNamedQuery(String name) throws Exception {
        throw new UnsupportedOperationException();
    }

    public SQLQuery createStoredProcedureNamedQuery(String name, Object parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public <T> TypedSQLQuery<T> createStoredProcedureNamedQuery(String name, Class<T> resultClass) throws Exception {
        throw new UnsupportedOperationException();
    }

    public <T> TypedSQLQuery<T> createStoredProcedureNamedQuery(String name, Class<T> resultClass, Object[] parameters) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String applyLock(String sql, Class<?> resultClass, LockOptions lockOptions) throws Exception {
        return this.lockManager.applyLock((SQLSession)this, sql, resultClass, lockOptions);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void batchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private int getCurrentBatchSize() {
        if (this.batchSize > 0) {
            return this.batchSize;
        }
        return this.currentBatchSize;
    }

    public boolean validationIsActive() {
        return this.validationActive;
    }

    public void activateValidation() {
        this.validationActive = true;
    }

    public void deactivateValidation() {
        this.validationActive = false;
    }

    public boolean hasNextValFromCacheSequence(String sequenceName) {
        if (!this.cacheSequenceNumbers.containsKey(sequenceName)) {
            return false;
        }
        return this.cacheSequenceNumbers.get(sequenceName).hasNextVal();
    }

    public void storeNextValToCacheSession(String sequenceName, Long firstValue, Long lastValue) {
        this.cacheSequenceNumbers.put(sequenceName, new NextValControl(firstValue - 1L, lastValue));
    }

    public Long getNextValFromCacheSequence(String sequenceName) {
        if (!this.cacheSequenceNumbers.containsKey(sequenceName)) {
            return null;
        }
        return this.cacheSequenceNumbers.get(sequenceName).getNextVal();
    }

    public void forceGenerationIdentifier(Object entity) throws Exception {
        if (entity == null) {
            return;
        }
        EntityCache entityCache = this.getEntityCacheManager().getEntityCache(entity.getClass());
        if (entityCache == null) {
            throw new SQLSessionException("Objeto n\u00e3o pode ser salvo pois a classe " + entity.getClass().getName() + " n\u00e3o foi localizada no cache de Entidades.");
        }
        if (!this.getIdentifier(entity).hasIdentifier()) {
            for (DescriptionField descriptionField : entityCache.getDescriptionFields()) {
                if (descriptionField.isAnyCollectionOrMap() || descriptionField.isVersioned() || descriptionField.isJoinTable()) continue;
                for (DescriptionColumn columnModified : descriptionField.getDescriptionColumns()) {
                    IdentifierGenerator identifierGenerator;
                    if (!columnModified.isPrimaryKey() || !columnModified.hasGenerator() || (identifierGenerator = IdentifierGeneratorFactory.createGenerator((SQLSession)this, (DescriptionColumn)columnModified)) instanceof IdentifierPostInsert) continue;
                    ReflectionUtils.setObjectValueByFieldName((Object)entity, (String)columnModified.getField().getName(), (Object)identifierGenerator.generate());
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            this.close();
        }
        super.finalize();
    }

    public int[] batch(String sql, Object[][] params) throws Exception {
        return this.queryRunner.batch((SQLSession)this, sql, params, this.showSql, this.formatSql, this.listeners, "");
    }

    public void validate(Object object) throws Exception {
        this.persister.getValidator().validateBean(object);
    }

    public void validate(Object object, Class<?> ... groups) throws Exception {
        this.persister.getValidator().validateBean(object, (Class[])groups);
    }

    public void invalidateConnection() throws SQLException {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = this.getSQLSessionFactory().getDataSource().getConnection();
    }

    public void setTenantId(Object value) {
        this.tenantId = value;
    }

    public Object getTenantId() {
        return this.tenantId;
    }

    public void setCompanyId(Object value) {
        this.companyId = value;
    }

    public Object getCompanyId() {
        return this.companyId;
    }

    public ExternalFileManager getExternalFileManager() {
        return this.externalFileManager;
    }

    public void notifyListeners(EventType eventType, Object oldObject, Object newObject) throws Exception {
        EntityCache entityCache = this.entityCacheManager.getEntityCache(newObject.getClass());
        if (entityCache.getEntityListeners().size() > 0) {
            for (EntityListener listener : entityCache.getEntityListeners()) {
                if (!listener.getEventType().equals((Object)eventType)) continue;
                if (listener.getMethod().getParameterCount() == 1) {
                    ReflectionUtils.invokeMethod((Method)listener.getMethod(), (Object)listener.getTargetObject(), (Object[])new Object[]{newObject});
                    continue;
                }
                if (listener.getMethod().getParameterCount() != 2) continue;
                ReflectionUtils.invokeMethod((Method)listener.getMethod(), (Object)listener.getTargetObject(), (Object[])new Object[]{oldObject, newObject});
            }
        }
        if (entityCache.getMethodListeners().size() > 0) {
            for (Method mt : entityCache.getMethodListeners().keySet()) {
                EventType ev = (EventType)entityCache.getMethodListeners().get(mt);
                if (!ev.equals((Object)eventType)) continue;
                if (mt.getParameterCount() == 0) {
                    ReflectionUtils.invokeMethod((Method)mt, (Object)newObject, (Object[])new Object[0]);
                    continue;
                }
                if (mt.getParameterCount() != 1) continue;
                ReflectionUtils.invokeMethod((Method)mt, (Object)newObject, (Object[])new Object[]{oldObject});
            }
        }
    }

    private class NextValControl {
        private Long lastValue;
        private Long value;

        public NextValControl(Long firstValue, Long lastValue) {
            this.lastValue = lastValue;
            this.value = firstValue;
        }

        public boolean hasNextVal() {
            return this.value + 1L <= this.lastValue;
        }

        public Long getNextVal() {
            Long l = this.value;
            Long l2 = this.value = Long.valueOf(this.value + 1L);
            return this.value;
        }
    }
}

