/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.metadata.accessor.impl;

import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.accessor.PropertyAccessor;
import br.com.anteros.persistence.metadata.accessor.PropertyAccessorFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;

public class PropertyAcessorFactoryImpl
implements PropertyAccessorFactory {
    private final ClassPool pool = new ClassPool();

    public PropertyAcessorFactoryImpl() {
        this.pool.appendSystemPath();
    }

    public Map<String, PropertyAccessor> createAccessors(Class<?> clazz) throws Exception {
        Field[] fields = ReflectionUtils.getAllDeclaredFields(clazz);
        HashMap<String, PropertyAccessor> temp = new HashMap<String, PropertyAccessor>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            PropertyAccessor accessor = this.createAccessor(clazz, field);
            temp.put(field.getName(), accessor);
            ++n2;
        }
        return Collections.unmodifiableMap(temp);
    }

    public PropertyAccessor createAccessor(Class<?> clazz, Field field) throws Exception {
        Method setterAccessor = ReflectionUtils.getSetterAccessor(clazz, (Field)field);
        Method getterAccessor = ReflectionUtils.getGetterAccessor(clazz, (Field)field);
        String classTemplate = "%s_%s_accessor";
        String getTemplate = "public Object get(Object source) { return ((%s)source).%s(); }";
        String setTemplate = "public void set(Object dest, Object value) { return ((%s)dest).%s((%s) value); }";
        String getMethod = String.format("public Object get(Object source) { return ((%s)source).%s(); }", clazz.getName(), getterAccessor.getName());
        String setMethod = field.getType().getName().equals("[B") ? String.format("public void set(Object dest, Object value) { return ((%s)dest).%s((%s) value); }", clazz.getName(), setterAccessor.getName(), "byte[]") : (field.getType() == Byte[].class ? String.format("public void set(Object dest, Object value) { return ((%s)dest).%s((%s) value); }", clazz.getName(), setterAccessor.getName(), "Byte[]") : String.format("public void set(Object dest, Object value) { return ((%s)dest).%s((%s) value); }", clazz.getName(), setterAccessor.getName(), field.getType().getName()));
        String className = String.format("%s_%s_accessor", clazz.getName(), field.getName());
        this.pool.importPackage(clazz.getName());
        CtClass ctClass = this.pool.makeClass(className);
        ctClass.addMethod(CtNewMethod.make((String)getMethod, (CtClass)ctClass));
        ctClass.addMethod(CtNewMethod.make((String)setMethod, (CtClass)ctClass));
        ctClass.setInterfaces(new CtClass[]{this.pool.get(PropertyAccessor.class.getName())});
        Class generated = ctClass.toClass();
        return (PropertyAccessor)generated.newInstance();
    }
}

