/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.session.impl;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.EntityCacheManager;
import br.com.anteros.persistence.session.AbstractSQLSessionFactory;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.configuration.SessionFactoryConfiguration;
import br.com.anteros.persistence.session.exception.SQLSessionException;
import br.com.anteros.persistence.session.impl.SQLQueryRunner;
import br.com.anteros.persistence.session.impl.SQLSessionImpl;
import br.com.anteros.persistence.session.query.AbstractSQLRunner;
import br.com.anteros.persistence.transaction.TransactionFactory;
import br.com.anteros.persistence.transaction.TransactionManagerLookup;
import br.com.anteros.persistence.transaction.impl.JDBCTransactionFactory;
import br.com.anteros.persistence.transaction.impl.TransactionException;
import java.sql.Connection;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;

public class SQLSessionFactoryImpl
extends AbstractSQLSessionFactory {
    private TransactionFactory transactionFactory;
    private static Logger log = LoggerProvider.getInstance().getLogger(SQLSessionFactoryImpl.class.getName());
    private TransactionManagerLookup transactionManagerLookup;
    private TransactionManager transactionManager;

    public SQLSessionFactoryImpl(EntityCacheManager entityCacheManager, DataSource dataSource, SessionFactoryConfiguration configuration) throws Exception {
        super(entityCacheManager, dataSource, configuration);
        String tmLookupClass = configuration.getProperty("transaction-manager-lookup");
        if (tmLookupClass == null) {
            log.info((Object)"No TransactionManagerLookup configured (in JTA environment, use of read-write or transactional second-level cache is not recommended)");
        } else {
            log.info((Object)("instantiating TransactionManagerLookup: " + tmLookupClass));
            try {
                this.transactionManagerLookup = (TransactionManagerLookup)ReflectionUtils.classForName((String)tmLookupClass).newInstance();
                log.info((Object)"instantiated TransactionManagerLookup");
                this.transactionManager = this.transactionManagerLookup.getTransactionManager();
            }
            catch (Exception e) {
                log.error((Object)"Could not instantiate TransactionManagerLookup", (Throwable)e);
                throw new TransactionException("Could not instantiate TransactionManagerLookup '" + tmLookupClass + "'");
            }
        }
    }

    @Override
    public SQLSession getCurrentSession() throws Exception {
        if (this.currentSessionContext == null) {
            throw new SQLSessionException("No CurrentSessionContext configured!");
        }
        return this.currentSessionContext.currentSession();
    }

    @Override
    public void beforeGenerateDDL(SQLSession session) throws Exception {
    }

    @Override
    public void afterGenerateDDL(SQLSession session) throws Exception {
    }

    public SQLSession openSession() throws Exception {
        return this.openSession(this.getDatasource().getConnection());
    }

    @Override
    protected TransactionFactory getTransactionFactory() {
        if (this.transactionFactory == null) {
            try {
                this.transactionFactory = this.buildTransactionFactory();
            }
            catch (Exception e) {
                throw new TransactionException("N\u00e3o foi poss\u00edvel criar a f\u00e1brica de transa\u00e7\u00f5es.", e);
            }
        }
        return this.transactionFactory;
    }

    protected TransactionFactory buildTransactionFactory() throws Exception {
        if (this.transactionFactory == null) {
            String tfLookupClass = this.configuration.getProperty("transaction-factory");
            if (tfLookupClass == null) {
                tfLookupClass = JDBCTransactionFactory.class.getName();
            }
            log.info((Object)("instantiating TransactionFactory: " + tfLookupClass));
            try {
                this.transactionFactory = (TransactionFactory)ReflectionUtils.classForName((String)tfLookupClass).newInstance();
                log.info((Object)"instantiated TransactionFactory");
            }
            catch (Exception e) {
                log.error((Object)"Could not instantiate TransactionManagerLookup", (Throwable)e);
                throw new TransactionException("Could not instantiate TransactionManagerLookup '" + tfLookupClass + "'");
            }
        }
        return this.transactionFactory;
    }

    @Override
    public TransactionManagerLookup getTransactionManagerLookup() throws Exception {
        return this.transactionManagerLookup;
    }

    @Override
    public TransactionManager getTransactionManager() throws Exception {
        return this.transactionManager;
    }

    public SQLSession openSession(Connection connection) throws Exception {
        this.setConfigurationClientInfo(connection);
        return new SQLSessionImpl(this, connection, this.getEntityCacheManager(), (AbstractSQLRunner)new SQLQueryRunner(), this.getDialect(), this.getShowSql(), this.isFormatSql(), this.getQueryTimeout(), this.getLockTimeout(), this.getTransactionFactory(), this.getBatchSize(), this.isUseBeanValidation());
    }
}

