/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.proxy;

import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.EntityCache;
import br.com.anteros.persistence.metadata.EntityManaged;
import br.com.anteros.persistence.metadata.FieldEntityValue;
import br.com.anteros.persistence.metadata.annotation.type.ScopeType;
import br.com.anteros.persistence.metadata.descriptor.DescriptionField;
import br.com.anteros.persistence.metadata.type.EntityStatus;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.cache.Cache;
import br.com.anteros.persistence.session.lock.LockOptions;
import br.com.anteros.persistence.session.query.SQLQuery;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import javassist.util.proxy.MethodHandler;

public class JavassistLazyLoadInterceptor
implements MethodHandler {
    private SQLSession session;
    private EntityCache entityCache;
    private Map<String, Object> columnKeyValuesTarget;
    private Cache transactionCache;
    private Object target;
    private Object owner;
    private DescriptionField descriptionFieldOwner;
    private Boolean constructed = Boolean.FALSE;
    private Boolean initialized = Boolean.FALSE;
    private Boolean processing = Boolean.FALSE;
    private LockOptions lockOptions;

    public JavassistLazyLoadInterceptor(SQLSession session, EntityCache entityCache, Map<String, Object> columKeyValues, Cache transactionCache, Object owner, DescriptionField descriptionField, LockOptions lockOptions) {
        this.session = session;
        this.entityCache = entityCache;
        this.columnKeyValuesTarget = columKeyValues;
        this.transactionCache = transactionCache;
        this.owner = owner;
        this.descriptionFieldOwner = descriptionField;
        this.lockOptions = lockOptions;
    }

    public Object invoke(Object proxy, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (this.constructed.booleanValue()) {
            if ("isInitialized".equals(thisMethod.getName())) {
                return this.isInitialized();
            }
            if ("initialize".equals(thisMethod.getName())) {
                this.getTargetObject();
                return null;
            }
            if ("initializeAndReturnObject".equals(thisMethod.getName())) {
                return this.initializeAndReturnObject();
            }
            Object target = this.getTargetObject();
            try {
                Object returnValue;
                if (this.entityCache != null && ReflectionUtils.isPublic((Class)this.entityCache.getEntityClass(), (Member)thisMethod)) {
                    Class<?> dc = thisMethod.getDeclaringClass();
                    if (!dc.isInstance(target)) {
                        throw new ClassCastException(target.getClass().getName());
                    }
                    returnValue = thisMethod.invoke(target, args);
                } else {
                    if (!thisMethod.isAccessible()) {
                        thisMethod.setAccessible(true);
                    }
                    returnValue = thisMethod.invoke(target, args);
                }
                return returnValue == target ? proxy : returnValue;
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object getTargetObject() throws Exception {
        if (!this.initialized.booleanValue()) {
            try {
                this.processing = Boolean.TRUE;
                EntityCache ownerEntityCache = null;
                if (this.owner != null && (ownerEntityCache = this.session.getEntityCacheManager().getEntityCache(this.owner.getClass())) != null) {
                    String uniqueId = ownerEntityCache.getCacheUniqueId(this.owner);
                    if (ownerEntityCache.getCacheScope().equals((Object)ScopeType.TRANSACTION) && this.transactionCache != null) {
                        this.transactionCache.put((Object)(ownerEntityCache.getEntityClass().getName() + "_" + uniqueId), this.owner, Integer.valueOf(ownerEntityCache.getMaxTimeCache()));
                    }
                }
                SQLQuery query = this.session.createQuery("");
                query.setLockOptions(this.lockOptions);
                query.allowDuplicateObjects(true);
                this.target = query.loadData(this.entityCache, this.owner, this.descriptionFieldOwner, this.columnKeyValuesTarget, this.transactionCache);
                EntityManaged entityManaged = this.session.getPersistenceContext().getEntityManaged(this.owner);
                if (entityManaged != null && entityManaged.getStatus() != EntityStatus.READ_ONLY) {
                    FieldEntityValue value = this.descriptionFieldOwner.getFieldEntityValue(this.session, this.owner, this.target);
                    entityManaged.addOriginalValue(value);
                    entityManaged.addLastValue(value);
                    entityManaged.getFieldsForUpdate().add(this.descriptionFieldOwner.getField().getName());
                }
                this.initialized = Boolean.TRUE;
            }
            finally {
                this.processing = Boolean.FALSE;
            }
        }
        return this.target;
    }

    public Object initializeAndReturnObject() throws Exception {
        return this.getTargetObject();
    }

    public SQLSession getSession() {
        return this.session;
    }

    public void setSession(SQLSession session) {
        this.session = session;
    }

    public EntityCache getEntityCache() {
        return this.entityCache;
    }

    public void setEntityCache(EntityCache entityCache) {
        this.entityCache = entityCache;
    }

    public Map<String, Object> getColumnKeyValuesTarget() {
        return this.columnKeyValuesTarget;
    }

    public void setColumnKeyValuesTarget(Map<String, Object> columnKeyValuesTarget) {
        this.columnKeyValuesTarget = columnKeyValuesTarget;
    }

    public Cache getTransactionCache() {
        return this.transactionCache;
    }

    public void setTransactionCache(Cache transactionCache) {
        this.transactionCache = transactionCache;
    }

    public Object getOwner() {
        return this.owner;
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    public DescriptionField getDescriptionFieldOwner() {
        return this.descriptionFieldOwner;
    }

    public void setDescriptionField(DescriptionField descriptionFieldOwner) {
        this.descriptionFieldOwner = descriptionFieldOwner;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public LockOptions getLockOptions() {
        return this.lockOptions;
    }
}

