/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.proxy;

import br.com.anteros.core.log.Logger;
import br.com.anteros.core.log.LoggerProvider;
import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.EntityCache;
import br.com.anteros.persistence.metadata.descriptor.DescriptionField;
import br.com.anteros.persistence.proxy.AnterosProxyObject;
import br.com.anteros.persistence.proxy.JavassistLazyLoadInterceptor;
import br.com.anteros.persistence.proxy.LazyLoadFactory;
import br.com.anteros.persistence.proxy.ProxyCreationException;
import br.com.anteros.persistence.proxy.collection.AnterosPersistentCollection;
import br.com.anteros.persistence.proxy.collection.ProxiedSQLLazyLoadList;
import br.com.anteros.persistence.proxy.collection.ProxiedSQLLazyLoadSet;
import br.com.anteros.persistence.proxy.lob.BlobLazyLoadProxy;
import br.com.anteros.persistence.proxy.lob.ClobLazyLoadProxy;
import br.com.anteros.persistence.proxy.lob.NClobLazyLoadProxy;
import br.com.anteros.persistence.session.SQLSession;
import br.com.anteros.persistence.session.cache.Cache;
import br.com.anteros.persistence.session.lock.LockOptions;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class JavassistLazyLoadFactory
implements LazyLoadFactory {
    private static Logger LOG = LoggerProvider.getInstance().getLogger(LazyLoadFactory.class);
    private static final MethodFilter FINALIZE_FILTER = new MethodFilter(){

        public boolean isHandled(Method m) {
            return m.getParameterTypes().length != 0 || !m.getName().equals("finalize");
        }
    };

    public Object createProxy(SQLSession session, Object targetObject, DescriptionField descriptionField, EntityCache targetEntityCache, Map<String, Object> columnKeyValues, Cache transactionCache, LockOptions lockOptions) throws Exception {
        LOG.debug((Object)("Criando proxy para objeto " + targetObject + " usando session " + session));
        Object newObject = null;
        if (descriptionField.isLob()) {
            if (descriptionField.getFieldClass().equals(Blob.class)) {
                return BlobLazyLoadProxy.createProxy((SQLSession)session, (Object)targetObject, (EntityCache)targetEntityCache, columnKeyValues, (DescriptionField)descriptionField);
            }
            if (descriptionField.getFieldClass().equals(Clob.class)) {
                return ClobLazyLoadProxy.createProxy((SQLSession)session, (Object)targetObject, (EntityCache)targetEntityCache, columnKeyValues, (DescriptionField)descriptionField);
            }
            if (descriptionField.getFieldClass().equals(NClob.class)) {
                return NClobLazyLoadProxy.createProxy((SQLSession)session, (Object)targetObject, (EntityCache)targetEntityCache, columnKeyValues, (DescriptionField)descriptionField);
            }
            throw new ProxyCreationException("N\u00e3o \u00e9 poss\u00edvel criar proxy para o tipo " + (descriptionField.getFieldClass() == byte[].class ? "byte[]" : descriptionField.getFieldClass()) + " do campo " + descriptionField.getField().getName() + " da classe " + targetEntityCache.getEntityClass().getSimpleName());
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setInterfaces(new Class[]{AnterosProxyObject.class});
        if (ReflectionUtils.isImplementsInterface(descriptionField.getField().getType(), Set.class)) {
            factory.setSuperclass(ProxiedSQLLazyLoadSet.class);
        } else if (ReflectionUtils.isImplementsInterface(descriptionField.getField().getType(), List.class)) {
            factory.setSuperclass(ProxiedSQLLazyLoadList.class);
        } else {
            factory.setSuperclass(descriptionField.getField().getType());
        }
        factory.setFilter(FINALIZE_FILTER);
        Class classNewObject = factory.createClass();
        newObject = classNewObject.newInstance();
        JavassistLazyLoadInterceptor lazyLoadInterceptor = new JavassistLazyLoadInterceptor(session, targetEntityCache, columnKeyValues, transactionCache, targetObject, descriptionField, lockOptions);
        ((ProxyObject)newObject).setHandler((MethodHandler)lazyLoadInterceptor);
        lazyLoadInterceptor.setConstructed(true);
        LOG.debug((Object)"Proxy criado");
        return newObject;
    }

    public boolean proxyIsInitialized(Object object) throws Exception {
        if (object instanceof AnterosProxyObject) {
            return ((AnterosProxyObject)object).isInitialized();
        }
        if (object instanceof AnterosPersistentCollection) {
            return ((AnterosPersistentCollection)object).isInitialized();
        }
        return false;
    }

    public boolean isProxyObject(Object object) throws Exception {
        if (object instanceof AnterosProxyObject) {
            return true;
        }
        if (object instanceof AnterosPersistentCollection) {
            return ((AnterosPersistentCollection)object).isProxied();
        }
        return false;
    }
}

