/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.serialization.jackson.AnterosPersistenceJacksonModule;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.text.SimpleDateFormat;

public class AnterosObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    private AnterosPersistenceJacksonModule module;
    private SQLSessionFactory sessionFactory;

    public AnterosObjectMapper(SQLSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.createModule();
        this.registerModule(this.module);
        this.enable(SerializationFeature.INDENT_OUTPUT);
        this.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        this.setDateFormat(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public AnterosPersistenceJacksonModule getModule() {
        return this.module;
    }

    public AnterosObjectMapper enable(AnterosPersistenceJacksonModule.Feature feature) {
        this.module.enable(feature);
        this.registerModule(this.module);
        return this;
    }

    public AnterosObjectMapper disable(AnterosPersistenceJacksonModule.Feature feature) {
        this.module.disable(feature);
        this.registerModule(this.module);
        return this;
    }

    protected void createModule() {
        this.module = new AnterosPersistenceJacksonModule(this.sessionFactory, this.getDeserializationContext());
    }
}

