/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.metadata.EntityCache;
import br.com.anteros.persistence.metadata.annotation.DiscriminatorColumn;
import br.com.anteros.persistence.metadata.annotation.DiscriminatorValue;
import br.com.anteros.persistence.metadata.annotation.Entity;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class AnterosAnnotatedAdapter
extends Annotated {
    private Annotated annotated;
    private SQLSessionFactory sessionFactory;

    public AnterosAnnotatedAdapter(SQLSessionFactory sessionFactory, Annotated annotated) {
        this.annotated = annotated;
        this.sessionFactory = sessionFactory;
    }

    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (acls.equals(JsonTypeInfo.class)) {
            return this.processJsonTypeInfo(acls);
        }
        if (acls.equals(JsonSubTypes.class)) {
            return this.processJsonSubTypes(acls);
        }
        if (acls.equals(JsonIdentityInfo.class)) {
            return this.processJsonIdentityInfo(acls);
        }
        return (A)this.annotated.getAnnotation(acls);
    }

    protected <A extends Annotation> A processJsonIdentityInfo(Class<A> acls) {
        if (this.annotated.getAnnotation(Entity.class) != null) {
            return (A)new JsonIdentityInfoImpl();
        }
        return null;
    }

    protected <A extends Annotation> A processJsonSubTypes(Class<A> acls) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotated.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorValue discriminatorValue = (DiscriminatorValue)this.annotated.getAnnotation(DiscriminatorValue.class);
        if (discriminatorColumn != null || discriminatorValue != null) {
            return (A)new JsonSubTypesImpl(discriminatorColumn, discriminatorValue);
        }
        return (A)this.annotated.getAnnotation(acls);
    }

    protected <A extends Annotation> A processJsonTypeInfo(Class<A> acls) {
        DiscriminatorColumn discriminatorColumn = (DiscriminatorColumn)this.annotated.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorValue discriminatorValue = (DiscriminatorValue)this.annotated.getAnnotation(DiscriminatorValue.class);
        if (discriminatorColumn != null || discriminatorValue != null) {
            return (A)new JsonTypeInfoImpl();
        }
        return (A)this.annotated.getAnnotation(acls);
    }

    public AnnotatedElement getAnnotated() {
        return this.annotated.getAnnotated();
    }

    protected int getModifiers() {
        return 0;
    }

    public String getName() {
        return this.annotated.getName();
    }

    public Type getGenericType() {
        return this.annotated.getGenericType();
    }

    public Class<?> getRawType() {
        return this.annotated.getRawType();
    }

    public Iterable<Annotation> annotations() {
        return this.annotated.annotations();
    }

    public boolean hasAnnotation(Class<?> acls) {
        return false;
    }

    public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
        return false;
    }

    public JavaType getType() {
        return null;
    }

    public boolean equals(Object o) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return null;
    }

    class TypeImpl
    implements JsonSubTypes.Type {
        private Class<?> _value;
        private String _name;

        public TypeImpl(Class<?> value, String name) {
            this._value = value;
            this._name = name;
        }

        public Class<? extends Annotation> annotationType() {
            return JsonSubTypes.Type.class;
        }

        public Class<?> value() {
            return this._value;
        }

        public String name() {
            return this._name;
        }
    }

    class JsonSubTypesImpl
    implements JsonSubTypes {
        private DiscriminatorColumn discriminatorColumn;
        private DiscriminatorValue discriminatorValue;

        public JsonSubTypesImpl(DiscriminatorColumn discriminatorColumn, DiscriminatorValue discriminatorValue) {
            this.discriminatorColumn = discriminatorColumn;
            this.discriminatorValue = discriminatorValue;
        }

        public Class<? extends Annotation> annotationType() {
            return JsonSubTypes.class;
        }

        public JsonSubTypes.Type[] value() {
            EntityCache[] entities;
            ArrayList<TypeImpl> result = new ArrayList<TypeImpl>();
            Class rawType = AnterosAnnotatedAdapter.this.annotated.getRawType();
            if (this.discriminatorValue != null) {
                EntityCache entityCache = AnterosAnnotatedAdapter.this.sessionFactory.getEntityCacheManager().getEntitySuperClass(rawType);
                rawType = entityCache.getEntityClass();
            }
            for (EntityCache entity : entities = AnterosAnnotatedAdapter.this.sessionFactory.getEntityCacheManager().getEntitiesBySuperClass(rawType)) {
                TypeImpl t = new TypeImpl(entity.getEntityClass(), entity.getDiscriminatorValue());
                result.add(t);
            }
            return result.toArray(new JsonSubTypes.Type[0]);
        }
    }

    class JsonIdentityInfoImpl
    implements JsonIdentityInfo {
        JsonIdentityInfoImpl() {
        }

        public Class<? extends Annotation> annotationType() {
            return JsonIdentityInfo.class;
        }

        public String property() {
            return "@id";
        }

        public Class<? extends ObjectIdGenerator<?>> generator() {
            return ObjectIdGenerators.UUIDGenerator.class;
        }

        public Class<?> scope() {
            return Object.class;
        }

        public Class<? extends ObjectIdResolver> resolver() {
            return SimpleObjectIdResolver.class;
        }
    }

    class JsonTypeInfoImpl
    implements JsonTypeInfo {
        JsonTypeInfoImpl() {
        }

        public Class<? extends Annotation> annotationType() {
            return JsonTypeInfo.class;
        }

        public JsonTypeInfo.Id use() {
            return JsonTypeInfo.Id.NAME;
        }

        public JsonTypeInfo.As include() {
            return JsonTypeInfo.As.PROPERTY;
        }

        public String property() {
            return "type";
        }

        public Class<?> defaultImpl() {
            return JsonTypeInfo.None.class;
        }

        public boolean visible() {
            return true;
        }
    }
}

