/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.proxy.AnterosProxyObject;
import br.com.anteros.persistence.serialization.jackson.JacksonSerializationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import java.io.IOException;

public class AnterosProxySerializer
extends JsonSerializer<AnterosProxyObject> {
    protected final BeanProperty _property;
    protected final boolean _forceLazyLoading;
    protected PropertySerializerMap _dynamicSerializers;

    public AnterosProxySerializer(boolean forceLazyLoading) {
        this._forceLazyLoading = forceLazyLoading;
        this._dynamicSerializers = PropertySerializerMap.emptyMap();
        this._property = null;
    }

    public boolean isEmpty(AnterosProxyObject value) {
        try {
            return value == null || this.findProxied(value) == null;
        }
        catch (Exception e) {
            throw new JacksonSerializationException(e);
        }
    }

    public void serialize(AnterosProxyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Object proxiedValue;
        try {
            proxiedValue = this.findProxied(value);
        }
        catch (Exception e) {
            throw new JacksonSerializationException(e);
        }
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serialize(proxiedValue, jgen, provider);
    }

    public void serializeWithType(AnterosProxyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        Object proxiedValue;
        try {
            proxiedValue = this.findProxied(value);
        }
        catch (Exception e) {
            throw new JacksonSerializationException(e);
        }
        if (proxiedValue == null) {
            provider.defaultSerializeNull(jgen);
            return;
        }
        this.findSerializer(provider, proxiedValue).serializeWithType(proxiedValue, jgen, provider, typeSer);
    }

    protected JsonSerializer<Object> findSerializer(SerializerProvider provider, Object value) throws IOException, JsonProcessingException {
        Class<?> type = value.getClass();
        PropertySerializerMap.SerializerAndMapResult result = this._dynamicSerializers.findAndAddPrimarySerializer(type, provider, this._property);
        if (this._dynamicSerializers != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    protected Object findProxied(AnterosProxyObject value) throws Exception {
        if (value instanceof AnterosProxyObject) {
            if (!this._forceLazyLoading && !value.isInitialized()) {
                return null;
            }
            return value.initializeAndReturnObject();
        }
        return null;
    }
}

