/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.metadata.annotation.Transient;
import br.com.anteros.persistence.serialization.jackson.AnterosAnnotatedAdapter;
import br.com.anteros.persistence.serialization.jackson.ModuleVersion;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import java.util.List;

public class AnterosAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    protected boolean _cfgCheckTransient;
    private SQLSessionFactory sessionFactory;

    public AnterosAnnotationIntrospector(SQLSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public AnterosAnnotationIntrospector setUseTransient(boolean state) {
        this._cfgCheckTransient = state;
        return this;
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public boolean hasIgnoreMarker(AnnotatedMember m) {
        if (m.hasAnnotation(Transient.class)) {
            return this._cfgCheckTransient && m.hasAnnotation(Transient.class);
        }
        return this._isIgnorable((Annotated)m);
    }

    public TypeResolverBuilder<?> findTypeResolver(MapperConfig<?> config, AnnotatedClass ac, JavaType baseType) {
        return super.findTypeResolver(config, ac, baseType);
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        AnterosAnnotatedAdapter annotatedAdapter = new AnterosAnnotatedAdapter(this.sessionFactory, ann);
        TypeResolverBuilder _findTypeResolver = super._findTypeResolver(config, (Annotated)annotatedAdapter, baseType);
        return _findTypeResolver;
    }

    public List<NamedType> findSubtypes(Annotated a) {
        return super.findSubtypes((Annotated)new AnterosAnnotatedAdapter(this.sessionFactory, a));
    }

    public ObjectIdInfo findObjectIdInfo(Annotated ann) {
        return super.findObjectIdInfo((Annotated)new AnterosAnnotatedAdapter(this.sessionFactory, ann));
    }

    public ObjectIdInfo findObjectReferenceInfo(Annotated ann, ObjectIdInfo objectIdInfo) {
        return super.findObjectReferenceInfo((Annotated)new AnterosAnnotatedAdapter(this.sessionFactory, ann), objectIdInfo);
    }
}

