/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.core.utils.ReflectionUtils;
import br.com.anteros.persistence.metadata.EntityCache;
import br.com.anteros.persistence.metadata.descriptor.DescriptionField;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class AnterosAnnotatedMemberAdapter
extends AnnotatedMember {
    private static final long serialVersionUID = 1L;
    private AnnotatedMember annotatedMember;
    private SQLSessionFactory sessionFactory;

    public AnterosAnnotatedMemberAdapter(SQLSessionFactory sessionFactory, AnnotatedMember annotated) {
        super(null);
        this.annotatedMember = annotated;
        this.sessionFactory = sessionFactory;
    }

    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (acls.equals(JsonManagedReference.class)) {
            if (this.annotatedMember instanceof AnnotatedMember) {
                EntityCache entityCache;
                Member member = this.annotatedMember.getMember();
                Field field = null;
                if (member instanceof Method) {
                    field = ReflectionUtils.getFieldByMethodSetter((Method)((Method)member));
                } else if (member instanceof Field) {
                    field = (Field)member;
                }
                if (field != null && (entityCache = this.sessionFactory.getEntityCacheManager().getEntityCache(member.getDeclaringClass())) != null) {
                    EntityCache[] caches = new EntityCache[]{entityCache};
                    if (entityCache.isAbstractClass()) {
                        caches = this.sessionFactory.getEntityCacheManager().getEntitiesBySuperClassIncluding(entityCache);
                    }
                    for (EntityCache cache : caches) {
                        DescriptionField descriptionField = cache.getDescriptionField(field.getName());
                        if (!descriptionField.isMappedBy()) continue;
                        return (A)new JsonManagedReferenceImpl(descriptionField.getMappedBy());
                    }
                }
            }
            return (A)this.annotatedMember.getAnnotation(acls);
        }
        if (acls.equals(JsonBackReference.class)) {
            if (this.annotatedMember instanceof AnnotatedMember) {
                DescriptionField descriptionField;
                EntityCache entityCache;
                Member member = this.annotatedMember.getMember();
                Field field = null;
                if (member instanceof Method) {
                    field = ReflectionUtils.getFieldByMethodSetter((Method)((Method)member));
                } else if (member instanceof Field) {
                    field = (Field)member;
                }
                if (field != null && (entityCache = this.sessionFactory.getEntityCacheManager().getEntityCache(member.getDeclaringClass())) != null && (descriptionField = entityCache.getDescriptionField(field.getName())).isRelationShip()) {
                    EntityCache entityCacheFK = this.sessionFactory.getEntityCacheManager().getEntityCache(descriptionField.getFieldClass());
                    EntityCache[] caches = new EntityCache[]{entityCacheFK};
                    if (entityCacheFK.isAbstractClass()) {
                        caches = this.sessionFactory.getEntityCacheManager().getEntitiesBySuperClassIncluding(entityCacheFK);
                    }
                    for (EntityCache cache : caches) {
                        if (!cache.hasDescriptionFieldWithMappedBy(entityCache.getEntityClass(), descriptionField.getField().getName())) continue;
                        return (A)new JsonBackReferenceImpl(descriptionField.getField().getName());
                    }
                }
            }
            return (A)this.annotatedMember.getAnnotation(acls);
        }
        return (A)this.annotatedMember.getAnnotation(acls);
    }

    public Annotated withAnnotations(AnnotationMap fallback) {
        return this.annotatedMember.withAnnotations(fallback);
    }

    public AnnotatedElement getAnnotated() {
        return this.annotatedMember.getAnnotated();
    }

    protected int getModifiers() {
        return 0;
    }

    public String getName() {
        return this.annotatedMember.getName();
    }

    public Type getGenericType() {
        return this.annotatedMember.getGenericType();
    }

    public Class<?> getRawType() {
        return this.annotatedMember.getRawType();
    }

    public Iterable<Annotation> annotations() {
        return this.annotatedMember.annotations();
    }

    protected AnnotationMap getAllAnnotations() {
        throw new RuntimeException("Not implemented method.");
    }

    public Class<?> getDeclaringClass() {
        return this.annotatedMember.getDeclaringClass();
    }

    public Member getMember() {
        return this.annotatedMember.getMember();
    }

    public void setValue(Object pojo, Object value) throws UnsupportedOperationException, IllegalArgumentException {
        this.annotatedMember.setValue(pojo, value);
    }

    public Object getValue(Object pojo) throws UnsupportedOperationException, IllegalArgumentException {
        return this.annotatedMember.getValue(pojo);
    }

    class JsonBackReferenceImpl
    implements JsonBackReference {
        private String _value;

        public JsonBackReferenceImpl(String value) {
            this._value = value;
        }

        public Class<? extends Annotation> annotationType() {
            return JsonBackReference.class;
        }

        public String value() {
            return this._value;
        }
    }

    class JsonManagedReferenceImpl
    implements JsonManagedReference {
        private String _value;

        public JsonManagedReferenceImpl(String value) {
            this._value = value;
        }

        public Class<? extends Annotation> annotationType() {
            return JsonManagedReference.class;
        }

        public String value() {
            return this._value;
        }
    }
}

