/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.metadata.annotation.Fetch;
import br.com.anteros.persistence.metadata.annotation.type.FetchMode;
import br.com.anteros.persistence.metadata.annotation.type.FetchType;
import br.com.anteros.persistence.proxy.AnterosProxyObject;
import br.com.anteros.persistence.proxy.collection.AnterosPersistentCollection;
import br.com.anteros.persistence.serialization.jackson.AnterosPersistenceJacksonModule;
import br.com.anteros.persistence.serialization.jackson.JacksonSerializationException;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;

public class AnterosProxyCollectionSerializer
extends JsonSerializer<Object>
implements ContextualSerializer {
    protected final int _features;
    protected final JsonSerializer<Object> _serializer;
    protected final SQLSessionFactory _sessionFactory;

    public AnterosProxyCollectionSerializer(JsonSerializer<?> serializer, int features, SQLSessionFactory sessionFactory) {
        this._serializer = serializer;
        this._features = features;
        this._sessionFactory = sessionFactory;
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (!AnterosProxyObject.class.isAssignableFrom(value.getClass()) && value instanceof AnterosPersistentCollection) {
            return this.findLazyValue((AnterosPersistentCollection)value) == null;
        }
        return false;
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (AnterosProxyObject.class.isAssignableFrom(value.getClass())) {
            Object proxiedValue;
            try {
                proxiedValue = this.findProxied(value);
            }
            catch (Exception e) {
                throw new JacksonSerializationException(e);
            }
            value = proxiedValue;
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        } else if (value instanceof AnterosPersistentCollection) {
            AnterosPersistentCollection coll = (AnterosPersistentCollection)value;
            if (!AnterosPersistenceJacksonModule.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.isInitialized()) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            value = coll;
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serialize(value, jgen, provider);
    }

    public void serializeWithType(Object value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        if (AnterosProxyObject.class.isAssignableFrom(value.getClass())) {
            Object proxiedValue;
            try {
                proxiedValue = this.findProxied(value);
            }
            catch (Exception e) {
                throw new JacksonSerializationException(e);
            }
            value = proxiedValue;
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        } else if (value instanceof AnterosPersistentCollection) {
            AnterosPersistentCollection coll = (AnterosPersistentCollection)value;
            if (!AnterosPersistenceJacksonModule.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.isInitialized()) {
                provider.defaultSerializeNull(jgen);
                return;
            }
            value = coll;
            if (value == null) {
                provider.defaultSerializeNull(jgen);
                return;
            }
        }
        if (this._serializer == null) {
            throw new JsonMappingException("PersistentCollection does not have serializer set");
        }
        this._serializer.serializeWithType(value, jgen, provider, typeSer);
    }

    protected Object findLazyValue(AnterosPersistentCollection coll) {
        if (!AnterosPersistenceJacksonModule.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !coll.isInitialized()) {
            return null;
        }
        if (this._sessionFactory != null) {
            coll.initialize();
        }
        return coll;
    }

    protected boolean usesLazyLoading(BeanProperty property) {
        if (property != null) {
            Fetch fetch = (Fetch)property.getAnnotation(Fetch.class);
            if (fetch != null && (fetch.mode() == FetchMode.ELEMENT_COLLECTION || fetch.mode() == FetchMode.ONE_TO_MANY || fetch.mode() == FetchMode.MANY_TO_MANY)) {
                return fetch.type() == FetchType.LAZY;
            }
            return !AnterosPersistenceJacksonModule.Feature.REQUIRE_EXPLICIT_LAZY_LOADING_MARKER.enabledIn(this._features);
        }
        return false;
    }

    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer ser = provider.handlePrimaryContextualization(this._serializer, property);
        if (!this.usesLazyLoading(property)) {
            return ser;
        }
        if (ser != this._serializer) {
            return new AnterosProxyCollectionSerializer(ser, this._features, this._sessionFactory);
        }
        return this;
    }

    protected Object findProxied(Object value) throws Exception {
        if (value instanceof AnterosProxyObject) {
            if (!AnterosPersistenceJacksonModule.Feature.FORCE_LAZY_LOADING.enabledIn(this._features) && !((AnterosProxyObject)value).isInitialized()) {
                return null;
            }
            return ((AnterosProxyObject)value).initializeAndReturnObject();
        }
        return null;
    }
}

