/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.serialization.jackson.AnterosAnnotationIntrospector;
import br.com.anteros.persistence.serialization.jackson.AnterosSerializerModifier;
import br.com.anteros.persistence.serialization.jackson.AnterosSerializers;
import br.com.anteros.persistence.serialization.jackson.ModuleVersion;
import br.com.anteros.persistence.session.SQLSessionFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.Serializers;

public class AnterosPersistenceJacksonModule
extends Module {
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int _moduleFeatures = DEFAULT_FEATURES;
    private DeserializationContext deserializationContext;
    private SQLSessionFactory sessionFactory;
    private AnterosSerializerModifier anterosSerializerModifier;
    private AnterosSerializers anterosSerializers;

    public AnterosPersistenceJacksonModule(SQLSessionFactory sessionFactory, DeserializationContext deserializationContext) {
        this.deserializationContext = deserializationContext;
        this.sessionFactory = sessionFactory;
    }

    public String getModuleName() {
        return "jackson-datatype-anteros";
    }

    public Version version() {
        return ModuleVersion.instance.version();
    }

    public void setupModule(Module.SetupContext context) {
        context.appendAnnotationIntrospector(this.annotationIntrospector());
        this.anterosSerializerModifier = new AnterosSerializerModifier(this._moduleFeatures, this.sessionFactory);
        this.anterosSerializers = new AnterosSerializers(this._moduleFeatures);
        context.addBeanSerializerModifier((BeanSerializerModifier)this.anterosSerializerModifier);
        context.addSerializers((Serializers)this.anterosSerializers);
    }

    protected AnnotationIntrospector annotationIntrospector() {
        AnterosAnnotationIntrospector ai = new AnterosAnnotationIntrospector(this.sessionFactory);
        ai.setUseTransient(this.isEnabled(Feature.USE_TRANSIENT_ANNOTATION));
        return ai;
    }

    public AnterosPersistenceJacksonModule enable(Feature f) {
        this._moduleFeatures |= f.getMask();
        if (this.anterosSerializerModifier != null) {
            this.anterosSerializerModifier.setFeatures(this._moduleFeatures);
        }
        if (this.anterosSerializers != null) {
            this.anterosSerializers.setForceLoading(Feature.FORCE_LAZY_LOADING.enabledIn(this._moduleFeatures));
        }
        return this;
    }

    public AnterosPersistenceJacksonModule disable(Feature f) {
        this._moduleFeatures &= ~f.getMask();
        if (this.anterosSerializerModifier != null) {
            this.anterosSerializerModifier.setFeatures(this._moduleFeatures);
        }
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    public AnterosPersistenceJacksonModule configure(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public static enum Feature {
        FORCE_LAZY_LOADING(false),
        USE_TRANSIENT_ANNOTATION(true),
        REQUIRE_EXPLICIT_LAZY_LOADING_MARKER(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

