/*******************************************************************************
 * Copyright 2012 Anteros Tecnologia
 *  
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *  
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package br.com.anteros.persistence.serialization.jackson;

import br.com.anteros.persistence.serialization.jackson.AnterosPersistenceJacksonModule.Feature;
import br.com.anteros.persistence.session.SQLSessionFactory;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class AnterosObjectMapper extends ObjectMapper {

	private static final long serialVersionUID = 1L;

	private AnterosPersistenceJacksonModule module;
	private SQLSessionFactory sessionFactory;

	public AnterosObjectMapper(SQLSessionFactory sessionFactory) {
		super();
		this.sessionFactory = sessionFactory;
		this.createModule();
		this.registerModule(module);
		this.enable(SerializationFeature.INDENT_OUTPUT);
		this.setSerializationInclusion(Include.NON_NULL);
	}

	public AnterosPersistenceJacksonModule getModule() {
		return module;
	}
	
	public AnterosObjectMapper enable(Feature feature){
		module.enable(feature);
		this.registerModule(module);
		return this;
	}
	
	public AnterosObjectMapper disable(Feature feature){
		module.disable(feature);
		this.registerModule(module);
		return this;
	}
	
	protected void createModule(){
		this.module = new AnterosPersistenceJacksonModule(sessionFactory, this.getDeserializationContext());
	}
	

}
