/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassUtils {
    private static final Set<String> JAVA_LANG = Collections.singleton("java.lang");

    public static String getName(Class<?> cl) {
        return ClassUtils.getName(cl, JAVA_LANG, Collections.emptySet());
    }

    public static String getFullName(Class<?> cl) {
        if (cl.isArray()) {
            return String.valueOf(ClassUtils.getFullName(cl.getComponentType())) + "[]";
        }
        String name = cl.getName();
        if (name.indexOf(36) > 0) {
            return String.valueOf(ClassUtils.getFullName(cl.getDeclaringClass())) + "." + cl.getSimpleName();
        }
        return name;
    }

    public static String getPackageName(Class<?> cl) {
        while (cl.isArray()) {
            cl = cl.getComponentType();
        }
        String name = cl.getName();
        int i = name.lastIndexOf(46);
        if (i > 0) {
            return name.substring(0, i);
        }
        return "";
    }

    public static String getName(Class<?> cl, Set<String> packages, Set<String> classes) {
        if (cl.isArray()) {
            return String.valueOf(ClassUtils.getName(cl.getComponentType(), packages, classes)) + "[]";
        }
        if (cl.getName().indexOf(36) > 0) {
            return String.valueOf(ClassUtils.getName(cl.getDeclaringClass(), packages, classes)) + "." + cl.getSimpleName();
        }
        String canonicalName = cl.getName();
        int i = canonicalName.lastIndexOf(46);
        if (i == -1) {
            return canonicalName;
        }
        String packageName = canonicalName.substring(0, i);
        if (packages.contains(packageName) || classes.contains(canonicalName)) {
            return cl.getSimpleName();
        }
        return canonicalName;
    }

    public static Class<?> normalize(Class<?> clazz) {
        Class<?> zuper;
        if (List.class.isAssignableFrom(clazz)) {
            return List.class;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return Set.class;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return Collection.class;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return Map.class;
        }
        if (clazz.getName().contains("$$") && (zuper = clazz.getSuperclass()) != null && !Object.class.equals(zuper)) {
            return zuper;
        }
        return clazz;
    }

    private ClassUtils() {
    }
}

