/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen.model;

import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeCategory;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimpleType
implements Type {
    private static final Map<String, Class<?>> PRIMITIVES = new HashMap();
    private final TypeCategory category;
    private final String fullName;
    private final String outerClassName;
    private final String packageName;
    private final String simpleName;
    private final String localName;
    private final List<Type> parameters;
    private final boolean primitiveClass;
    private final boolean finalClass;
    private Type arrayType;
    private Type componentType;
    private transient Class<?> javaClass;

    static {
        for (Class cl : Arrays.asList(Byte.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Boolean.TYPE, Character.TYPE)) {
            PRIMITIVES.put(cl.getName(), cl);
        }
    }

    public SimpleType(String fullName, String packageName, String simpleName, Type ... parameters) {
        this(TypeCategory.SIMPLE, fullName, packageName, simpleName, false, false, Arrays.asList(parameters));
    }

    public SimpleType(String simpleName) {
        this(TypeCategory.SIMPLE, simpleName, "", simpleName, false, false, new Type[0]);
    }

    public SimpleType(Type type, List<Type> parameters) {
        this(type.getCategory(), type.getFullName(), type.getPackageName(), type.getSimpleName(), type.isPrimitive(), type.isFinal(), parameters);
    }

    public SimpleType(Type type, Type ... parameters) {
        this(type.getCategory(), type.getFullName(), type.getPackageName(), type.getSimpleName(), type.isPrimitive(), type.isFinal(), Arrays.asList(parameters));
    }

    public SimpleType(TypeCategory category, String fullName, String packageName, String simpleName, boolean primitiveClass, boolean finalClass, List<Type> parameters) {
        this.category = category;
        this.fullName = fullName;
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.localName = packageName.length() > 0 ? fullName.substring(packageName.length() + 1) : fullName;
        this.outerClassName = fullName.substring(packageName.length() + 1).contains(".") ? fullName.substring(0, fullName.lastIndexOf(46)) : fullName;
        this.primitiveClass = primitiveClass;
        this.finalClass = finalClass;
        this.parameters = parameters;
    }

    public SimpleType(TypeCategory typeCategory, String fullName, String packageName, String simpleName, boolean p, boolean f, Type ... parameters) {
        this(typeCategory, fullName, packageName, simpleName, p, f, Arrays.asList(parameters));
    }

    @Override
    public Type as(TypeCategory c) {
        if (this.category != c) {
            return new SimpleType(c, this.fullName, this.packageName, this.simpleName, this.primitiveClass, this.finalClass, this.parameters);
        }
        return this;
    }

    @Override
    public Type asArrayType() {
        if (this.arrayType == null) {
            String newFullName = String.valueOf(this.getFullName()) + "[]";
            String newSimpleName = String.valueOf(this.getSimpleName()) + "[]";
            this.arrayType = new SimpleType(TypeCategory.ARRAY, newFullName, this.getPackageName(), newSimpleName, false, false, new Type[0]);
        }
        return this.arrayType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Type) {
            Type t = (Type)o;
            return t.getFullName().equals(this.fullName) && t.getParameters().equals(this.parameters);
        }
        return false;
    }

    @Override
    public TypeCategory getCategory() {
        return this.category;
    }

    @Override
    public Type getComponentType() {
        if (this.fullName.endsWith("[]")) {
            if (this.componentType == null) {
                String newFullName = this.fullName.substring(0, this.fullName.length() - 2);
                String newSimpleName = this.simpleName.substring(0, this.simpleName.length() - 2);
                this.componentType = new SimpleType(TypeCategory.SIMPLE, newFullName, this.getPackageName(), newSimpleName, false, false, new Type[0]);
            }
            return this.componentType;
        }
        return null;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getGenericName(boolean asArgType) {
        return this.getGenericName(asArgType, Collections.singleton("java.lang"), Collections.emptySet());
    }

    @Override
    public String getGenericName(boolean asArgType, Set<String> packages, Set<String> classes) {
        if (this.parameters.isEmpty()) {
            return this.getRawName(packages, classes);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRawName(packages, classes));
        builder.append("<");
        boolean first = true;
        for (Type parameter : this.parameters) {
            if (!first) {
                builder.append(", ");
            }
            if (parameter == null || parameter.getFullName().equals(this.fullName)) {
                builder.append("?");
            } else {
                builder.append(parameter.getGenericName(false, packages, classes));
            }
            first = false;
        }
        builder.append(">");
        return builder.toString();
    }

    @Override
    public Class<?> getJavaClass() {
        if (this.javaClass == null) {
            String className = this.packageName.length() > 0 ? String.valueOf(this.packageName) + "." + this.localName.replace('.', '$') : this.localName.replace('.', '$');
            try {
                if (className.endsWith("[]")) {
                    Class<?> component = this.getComponentType().getJavaClass();
                    this.javaClass = Array.newInstance(component, 0).getClass();
                } else {
                    this.javaClass = PRIMITIVES.containsKey(className) ? PRIMITIVES.get(className) : Class.forName(className);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.javaClass;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public List<Type> getParameters() {
        return this.parameters;
    }

    @Override
    public String getRawName(Set<String> packages, Set<String> classes) {
        if (packages.contains(this.packageName) || classes.contains(this.fullName) || classes.contains(this.outerClassName)) {
            return this.localName;
        }
        return this.fullName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    @Override
    public boolean isFinal() {
        return this.finalClass;
    }

    @Override
    public boolean isPrimitive() {
        return this.primitiveClass;
    }

    public String toString() {
        return this.getGenericName(true);
    }
}

