/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.EntityType;
import br.com.anteros.persistence.apt.codegen.Supertype;
import br.com.anteros.persistence.apt.codegen.model.SimpleType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import br.com.anteros.persistence.apt.codegen.model.TypeExtends;
import br.com.anteros.persistence.apt.codegen.model.TypeSuper;
import com.google.common.base.Objects;

public final class TypeResolver {
    public static Type resolve(Type type, Type declaringType, EntityType context) {
        Type resolved = TypeResolver.unwrap(type);
        String varName = TypeResolver.getVarName(resolved);
        if (varName != null) {
            resolved = TypeResolver.resolveVar(resolved, varName, declaringType, context);
        } else if (!resolved.getParameters().isEmpty()) {
            resolved = TypeResolver.resolveWithParameters(resolved, declaringType, context);
        }
        if (type instanceof EntityType) {
            resolved = !TypeResolver.unwrap(type).equals(resolved) ? new EntityType(resolved, ((EntityType)type).getSuperTypes()) : type;
        }
        return resolved;
    }

    private static Type resolveVar(Type resolved, String varName, Type declaringType, EntityType context) {
        int index = -1;
        int i = 0;
        while (i < declaringType.getParameters().size()) {
            Type param = TypeResolver.unwrap(declaringType.getParameters().get(i));
            if (param instanceof TypeExtends && Objects.equal((Object)((TypeExtends)param).getVarName(), (Object)varName)) {
                index = i;
            }
            ++i;
        }
        if (index == -1) {
            throw new IllegalStateException("Did not find type " + varName + " in " + declaringType.getParameters());
        }
        Supertype type = context.getSuperType();
        while (!type.getEntityType().equals(declaringType)) {
            type = type.getEntityType().getSuperType();
        }
        if (!type.getType().getParameters().isEmpty()) {
            return type.getType().getParameters().get(index);
        }
        return resolved;
    }

    private static Type resolveWithParameters(Type type, Type declaringType, EntityType context) {
        Type[] params = new Type[type.getParameters().size()];
        boolean transformed = false;
        int i = 0;
        while (i < type.getParameters().size()) {
            Type param = type.getParameters().get(i);
            if (param != null && !param.getFullName().equals(type.getFullName())) {
                params[i] = TypeResolver.resolve(param, declaringType, context);
                if (!params[i].equals(param)) {
                    transformed = true;
                }
            }
            ++i;
        }
        if (transformed) {
            return new SimpleType(type, params);
        }
        return type;
    }

    private static String getVarName(Type type) {
        if (type instanceof TypeExtends) {
            return ((TypeExtends)type).getVarName();
        }
        if (type instanceof TypeSuper) {
            return ((TypeSuper)type).getVarName();
        }
        return null;
    }

    private static Type unwrap(Type type) {
        if (type instanceof EntityType) {
            return ((EntityType)type).getInnerType();
        }
        return type;
    }

    private TypeResolver() {
    }
}

