/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.AbstractEvaluatorFactory;
import br.com.anteros.persistence.apt.codegen.CodegenException;
import br.com.anteros.persistence.apt.codegen.MemFileManager;
import br.com.anteros.persistence.apt.codegen.MemSourceFileObject;
import br.com.anteros.persistence.apt.codegen.SimpleCompiler;
import br.com.anteros.persistence.apt.codegen.model.ClassType;
import br.com.anteros.persistence.apt.codegen.model.Type;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JDKEvaluatorFactory
extends AbstractEvaluatorFactory {
    private final MemFileManager fileManager;
    private final String classpath;
    private final List<String> compilationOptions;
    private final JavaCompiler compiler;

    public JDKEvaluatorFactory(URLClassLoader parent) {
        this(parent, ToolProvider.getSystemJavaCompiler());
    }

    public JDKEvaluatorFactory(URLClassLoader parent, JavaCompiler compiler) {
        this.fileManager = new MemFileManager(parent, compiler.getStandardFileManager(null, null, null));
        this.compiler = compiler;
        this.classpath = SimpleCompiler.getClassPath(parent);
        this.loader = this.fileManager.getClassLoader(StandardLocation.CLASS_OUTPUT);
        this.compilationOptions = Arrays.asList("-classpath", this.classpath, "-g:none");
    }

    @Override
    protected void compile(String source, ClassType projectionType, String[] names, Type[] types, String id, Map<String, Object> constants) throws IOException {
        StringWriter out = new StringWriter();
        MemSourceFileObject javaFileObject = new MemSourceFileObject(id, source = this.createSource(source, projectionType, names, types, id, constants));
        JavaCompiler.CompilationTask task = this.compiler.getTask(out, this.fileManager, null, this.compilationOptions, null, Collections.singletonList(javaFileObject));
        if (!task.call().booleanValue()) {
            throw new CodegenException("Compilation of " + source + " failed.\n" + ((Object)out).toString());
        }
    }
}

