/*
 * Decompiled with CFR 0.152.
 */
package br.com.anteros.persistence.apt.codegen;

import br.com.anteros.persistence.apt.codegen.CodegenException;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.jar.Manifest;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class SimpleCompiler
implements JavaCompiler {
    private static final Joiner pathJoiner = Joiner.on((String)File.pathSeparator);
    private final ClassLoader classLoader;
    private String classPath;
    private final JavaCompiler compiler;

    private static boolean isSureFireBooter(URLClassLoader cl) {
        URL[] uRLArray = cl.getURLs();
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            if (url.getPath().contains("surefirebooter")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getClassPath(URLClassLoader cl) {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            if (SimpleCompiler.isSureFireBooter(cl)) {
                URL url = cl.findResource("META-INF/MANIFEST.MF");
                Manifest manifest = new Manifest(url.openStream());
                String classpath = manifest.getMainAttributes().getValue("Class-Path");
                String[] stringArray = classpath.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = stringArray[n2];
                    URL entryUrl = new URL(entry);
                    String decodedPath = URLDecoder.decode(entryUrl.getPath(), "UTF-8");
                    paths.add(new File(decodedPath).getAbsolutePath());
                    ++n2;
                }
            } else {
                ClassLoader c = cl;
                while (c instanceof URLClassLoader) {
                    URL[] uRLArray = c.getURLs();
                    int n = uRLArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        URL url = uRLArray[n3];
                        String decodedPath = URLDecoder.decode(url.getPath(), "UTF-8");
                        paths.add(new File(decodedPath).getAbsolutePath());
                        ++n3;
                    }
                    c = c.getParent();
                }
            }
            return pathJoiner.join(paths);
        }
        catch (UnsupportedEncodingException e) {
            throw new CodegenException(e);
        }
        catch (IOException e) {
            throw new CodegenException(e);
        }
    }

    public SimpleCompiler() {
        this(ToolProvider.getSystemJavaCompiler(), Thread.currentThread().getContextClassLoader());
    }

    public SimpleCompiler(JavaCompiler compiler, ClassLoader classLoader) {
        this.compiler = compiler;
        this.classLoader = classLoader;
    }

    private String getClasspath() {
        if (this.classPath == null) {
            if (this.classLoader instanceof URLClassLoader) {
                this.classPath = SimpleCompiler.getClassPath((URLClassLoader)this.classLoader);
            } else {
                throw new IllegalArgumentException("Unsupported ClassLoader " + this.classLoader);
            }
        }
        return this.classPath;
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return this.compiler.getSourceVersions();
    }

    @Override
    public StandardJavaFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        return this.compiler.getStandardFileManager(diagnosticListener, locale, charset);
    }

    @Override
    public JavaCompiler.CompilationTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        return this.compiler.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits);
    }

    @Override
    public int isSupportedOption(String option) {
        return this.compiler.isSupportedOption(option);
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (a.equals("-classpath")) {
                return this.compiler.run(in, out, err, arguments);
            }
            ++n2;
        }
        ArrayList<String> args = new ArrayList<String>(arguments.length + 2);
        args.add("-classpath");
        args.add(this.getClasspath());
        String[] stringArray2 = arguments;
        int n3 = arguments.length;
        n = 0;
        while (n < n3) {
            String arg = stringArray2[n];
            args.add(arg);
            ++n;
        }
        return this.compiler.run(in, out, err, args.toArray(new String[args.size()]));
    }
}

